/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.relational;

import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.metamodel.relational.AbstractConstraint;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Column;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Constraint;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Table;

public class UniqueKey
extends AbstractConstraint
implements Constraint {
    protected UniqueKey(Table table, String name) {
        super(table, name);
    }

    @Override
    public String getExportIdentifier() {
        StringBuilder sb = new StringBuilder(this.getTable().getLoggableValueQualifier());
        sb.append(".UK");
        for (Column column : this.getColumns()) {
            sb.append('_').append(column.getColumnName().getName());
        }
        return sb.toString();
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        String s = dialect.getUniqueDelegate().getAlterTableToAddUniqueKeyCommand(this);
        return StringHelper.toArrayElement(s);
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        String s = dialect.getUniqueDelegate().getAlterTableToDropUniqueKeyCommand(this);
        return StringHelper.toArrayElement(s);
    }

    @Override
    protected String sqlConstraintStringInAlterTable(Dialect dialect) {
        return "";
    }
}

