/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute;

import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JPADotNames;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JandexHelper;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.ColumnValues;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;

public class AttributeOverride {
    private static final String PROPERTY_PATH_SEPARATOR = ".";
    private final ColumnValues columnValues;
    private final String attributePath;

    public AttributeOverride(AnnotationInstance attributeOverrideAnnotation) {
        this(null, attributeOverrideAnnotation);
    }

    public AttributeOverride(String prefix, AnnotationInstance attributeOverrideAnnotation) {
        if (attributeOverrideAnnotation == null) {
            throw new IllegalArgumentException("An AnnotationInstance needs to be passed");
        }
        if (!JPADotNames.ATTRIBUTE_OVERRIDE.equals(attributeOverrideAnnotation.name())) {
            throw new AssertionFailure("A @AttributeOverride annotation needs to be passed to the constructor");
        }
        this.columnValues = new ColumnValues(JandexHelper.getValue(attributeOverrideAnnotation, "column", AnnotationInstance.class));
        this.attributePath = this.createAttributePath(prefix, JandexHelper.getValue(attributeOverrideAnnotation, "name", String.class));
    }

    public ColumnValues getColumnValues() {
        return this.columnValues;
    }

    public String getAttributePath() {
        return this.attributePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributeOverride");
        sb.append("{columnValues=").append(this.columnValues);
        sb.append(", attributePath='").append(this.attributePath).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeOverride that = (AttributeOverride)o;
        if (this.attributePath != null ? !this.attributePath.equals(that.attributePath) : that.attributePath != null) {
            return false;
        }
        return !(this.columnValues != null ? !this.columnValues.equals(that.columnValues) : that.columnValues != null);
    }

    public int hashCode() {
        int result = this.columnValues != null ? this.columnValues.hashCode() : 0;
        result = 31 * result + (this.attributePath != null ? this.attributePath.hashCode() : 0);
        return result;
    }

    private String createAttributePath(String prefix, String name) {
        String path = "";
        if (StringHelper.isNotEmpty(prefix)) {
            path = path + prefix;
        }
        if (StringHelper.isNotEmpty(path) && !path.endsWith(PROPERTY_PATH_SEPARATOR)) {
            path = path + PROPERTY_PATH_SEPARATOR;
        }
        path = path + name;
        return path;
    }
}

