/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.type;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.AnnotationException;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JPADotNames;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JandexHelper;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.type.AbstractAttributeTypeResolver;
import org.evosuite.shaded.org.hibernate.type.EnumType;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;

public class EnumeratedTypeResolver
extends AbstractAttributeTypeResolver {
    private final MappedAttribute mappedAttribute;
    private final boolean isMapKey;

    public EnumeratedTypeResolver(MappedAttribute mappedAttribute) {
        if (mappedAttribute == null) {
            throw new AssertionFailure("MappedAttribute is null");
        }
        this.mappedAttribute = mappedAttribute;
        this.isMapKey = false;
    }

    @Override
    protected AnnotationInstance getTypeDeterminingAnnotationInstance() {
        return JandexHelper.getSingleAnnotation(this.mappedAttribute.annotations(), JPADotNames.ENUMERATED);
    }

    @Override
    public String resolveHibernateTypeName(AnnotationInstance enumeratedAnnotation) {
        boolean isEnum = this.mappedAttribute.getAttributeType().isEnum();
        if (!isEnum) {
            if (enumeratedAnnotation != null) {
                throw new AnnotationException("Attribute " + this.mappedAttribute.getName() + " is not a Enumerated type, but has a @Enumerated annotation.");
            }
            return null;
        }
        return EnumType.class.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map<String, String> resolveHibernateTypeParameters(AnnotationInstance annotationInstance) {
        HashMap<String, String> typeParameters = new HashMap<String, String>();
        typeParameters.put("enumClass", this.mappedAttribute.getAttributeType().getName());
        if (annotationInstance != null) {
            javax.persistence.EnumType enumType = JandexHelper.getEnumValue(annotationInstance, "value", javax.persistence.EnumType.class);
            if (javax.persistence.EnumType.ORDINAL.equals((Object)enumType)) {
                typeParameters.put("type", String.valueOf(4));
                return typeParameters;
            } else {
                if (!javax.persistence.EnumType.STRING.equals((Object)enumType)) throw new AssertionFailure("Unknown EnumType: " + (Object)((Object)enumType));
                typeParameters.put("type", String.valueOf(12));
            }
            return typeParameters;
        } else {
            typeParameters.put("type", String.valueOf(4));
        }
        return typeParameters;
    }
}

