/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.type;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JPADotNames;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JandexHelper;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.type.AbstractAttributeTypeResolver;
import org.evosuite.shaded.org.hibernate.type.CharacterArrayClobType;
import org.evosuite.shaded.org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.evosuite.shaded.org.hibernate.type.SerializableToBlobType;
import org.evosuite.shaded.org.hibernate.type.StandardBasicTypes;
import org.evosuite.shaded.org.hibernate.type.WrappedMaterializedBlobType;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;

public class LobTypeResolver
extends AbstractAttributeTypeResolver {
    private final MappedAttribute mappedAttribute;

    public LobTypeResolver(MappedAttribute mappedAttribute) {
        if (mappedAttribute == null) {
            throw new AssertionFailure("MappedAttribute is null");
        }
        this.mappedAttribute = mappedAttribute;
    }

    @Override
    protected AnnotationInstance getTypeDeterminingAnnotationInstance() {
        return JandexHelper.getSingleAnnotation(this.mappedAttribute.annotations(), JPADotNames.LOB);
    }

    @Override
    public String resolveHibernateTypeName(AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        String type = null;
        type = Clob.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.CLOB.getName() : (Blob.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.BLOB.getName() : (String.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.MATERIALIZED_CLOB.getName() : (Character[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? CharacterArrayClobType.class.getName() : (char[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? PrimitiveCharacterArrayClobType.class.getName() : (Byte[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? WrappedMaterializedBlobType.class.getName() : (byte[].class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? StandardBasicTypes.MATERIALIZED_BLOB.getName() : (Serializable.class.isAssignableFrom(this.mappedAttribute.getAttributeType()) ? SerializableToBlobType.class.getName() : "blob")))))));
        return type;
    }

    @Override
    protected Map<String, String> resolveHibernateTypeParameters(AnnotationInstance annotationInstance) {
        if (this.getExplicitHibernateTypeName().equals(SerializableToBlobType.class.getName())) {
            HashMap<String, String> typeParameters = new HashMap<String, String>();
            typeParameters.put("classname", this.mappedAttribute.getAttributeType().getName());
            return typeParameters;
        }
        return null;
    }
}

