/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.AccessType;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JPADotNames;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JandexHelper;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.EmbeddableClass;
import org.evosuite.shaded.org.jboss.jandex.ClassInfo;
import org.evosuite.shaded.org.jboss.jandex.DotName;

public class EmbeddableHierarchy
implements Iterable<EmbeddableClass> {
    private final AccessType defaultAccessType;
    private final List<EmbeddableClass> embeddables;

    public static EmbeddableHierarchy createEmbeddableHierarchy(Class<?> embeddableClass, String propertyName, AccessType accessType, AnnotationBindingContext context) {
        ClassInfo embeddableClassInfo = context.getClassInfo(embeddableClass.getName());
        if (embeddableClassInfo == null) {
            throw new AssertionFailure(String.format("The specified class %s cannot be found in the annotation index", embeddableClass.getName()));
        }
        if (JandexHelper.getSingleAnnotation(embeddableClassInfo, JPADotNames.EMBEDDABLE) == null) {
            throw new AssertionFailure(String.format("The specified class %s is not annotated with @Embeddable even though it is as embeddable", embeddableClass.getName()));
        }
        ArrayList<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
        for (Class<?> clazz = embeddableClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            ClassInfo tmpClassInfo = context.getIndex().getClassByName(DotName.createSimple(clazz.getName()));
            if (tmpClassInfo == null) continue;
            classInfoList.add(0, tmpClassInfo);
        }
        return new EmbeddableHierarchy(classInfoList, propertyName, context, accessType);
    }

    private EmbeddableHierarchy(List<ClassInfo> classInfoList, String propertyName, AnnotationBindingContext context, AccessType defaultAccessType) {
        this.defaultAccessType = defaultAccessType;
        context.resolveAllTypes(classInfoList.get(classInfoList.size() - 1).name().toString());
        this.embeddables = new ArrayList<EmbeddableClass>();
        EmbeddableClass parent = null;
        for (ClassInfo info : classInfoList) {
            EmbeddableClass embeddable = new EmbeddableClass(info, propertyName, parent, defaultAccessType, context);
            this.embeddables.add(embeddable);
            parent = embeddable;
        }
    }

    public AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    @Override
    public Iterator<EmbeddableClass> iterator() {
        return this.embeddables.iterator();
    }

    public EmbeddableClass getLeaf() {
        return this.embeddables.get(this.embeddables.size() - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EmbeddableHierarchy");
        sb.append("{defaultAccessType=").append((Object)this.defaultAccessType);
        sb.append(", embeddables=").append(this.embeddables);
        sb.append('}');
        return sb.toString();
    }
}

