/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.internal.jaxb.Origin;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CustomSQL;
import org.evosuite.shaded.org.hibernate.metamodel.source.LocalBindingContext;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.AssociationAttribute;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.ToOneAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.ComponentAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.EmbeddableClass;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.EntityClass;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.AttributeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.ConstraintSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.EntitySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.SubclassEntitySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.TableSource;

public class EntitySourceImpl
implements EntitySource {
    private final EntityClass entityClass;
    private final Set<SubclassEntitySource> subclassEntitySources;

    public EntitySourceImpl(EntityClass entityClass) {
        this.entityClass = entityClass;
        this.subclassEntitySources = new HashSet<SubclassEntitySource>();
    }

    public EntityClass getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Origin getOrigin() {
        return this.entityClass.getLocalBindingContext().getOrigin();
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.entityClass.getLocalBindingContext();
    }

    @Override
    public String getEntityName() {
        return this.entityClass.getName();
    }

    @Override
    public String getClassName() {
        return this.entityClass.getName();
    }

    @Override
    public String getJpaEntityName() {
        return this.entityClass.getExplicitEntityName();
    }

    @Override
    public TableSource getPrimaryTable() {
        return this.entityClass.getPrimaryTableSource();
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isLazy() {
        return this.entityClass.isLazy();
    }

    @Override
    public String getProxy() {
        return this.entityClass.getProxy();
    }

    @Override
    public int getBatchSize() {
        return this.entityClass.getBatchSize();
    }

    @Override
    public boolean isDynamicInsert() {
        return this.entityClass.isDynamicInsert();
    }

    @Override
    public boolean isDynamicUpdate() {
        return this.entityClass.isDynamicUpdate();
    }

    @Override
    public boolean isSelectBeforeUpdate() {
        return this.entityClass.isSelectBeforeUpdate();
    }

    @Override
    public String getCustomTuplizerClassName() {
        return this.entityClass.getCustomTuplizer();
    }

    @Override
    public String getCustomPersisterClassName() {
        return this.entityClass.getCustomPersister();
    }

    @Override
    public String getCustomLoaderName() {
        return this.entityClass.getCustomLoaderQueryName();
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return this.entityClass.getCustomInsert();
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return this.entityClass.getCustomUpdate();
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return this.entityClass.getCustomDelete();
    }

    @Override
    public List<String> getSynchronizedTableNames() {
        return this.entityClass.getSynchronizedTableNames();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Collections.emptySet();
    }

    @Override
    public String getPath() {
        return this.entityClass.getName();
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> attributeList = new ArrayList<AttributeSource>();
        for (BasicAttribute attribute : this.entityClass.getSimpleAttributes()) {
            attributeList.add(new SingularAttributeSourceImpl(attribute));
        }
        for (EmbeddableClass component : this.entityClass.getEmbeddedClasses().values()) {
            attributeList.add(new ComponentAttributeSourceImpl(component, "", this.entityClass.getAttributeOverrideMap()));
        }
        for (AssociationAttribute associationAttribute : this.entityClass.getAssociationAttributes()) {
            attributeList.add(new ToOneAttributeSourceImpl(associationAttribute));
        }
        return attributeList;
    }

    @Override
    public void add(SubclassEntitySource subclassEntitySource) {
        this.subclassEntitySources.add(subclassEntitySource);
    }

    @Override
    public Iterable<SubclassEntitySource> subclassEntitySources() {
        return this.subclassEntitySources;
    }

    @Override
    public String getDiscriminatorMatchValue() {
        return this.entityClass.getDiscriminatorMatchValue();
    }

    @Override
    public Iterable<ConstraintSource> getConstraints() {
        return this.entityClass.getConstraintSources();
    }

    @Override
    public List<JpaCallbackClass> getJpaCallbackClasses() {
        return this.entityClass.getJpaCallbacks();
    }

    @Override
    public Iterable<TableSource> getSecondaryTables() {
        return this.entityClass.getSecondaryTableSources();
    }
}

