/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity;

import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.EntityMode;
import org.evosuite.shaded.org.hibernate.cfg.NotYetImplementedException;
import org.evosuite.shaded.org.hibernate.engine.OptimisticLockStyle;
import org.evosuite.shaded.org.hibernate.metamodel.binding.Caching;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.DiscriminatorSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.SimpleIdentifierSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.EntityClass;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.EntitySourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.entity.IdType;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.DiscriminatorSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.IdentifierSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.RootEntitySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.SingularAttributeSource;

public class RootEntitySourceImpl
extends EntitySourceImpl
implements RootEntitySource {
    public RootEntitySourceImpl(EntityClass entityClass) {
        super(entityClass);
    }

    @Override
    public IdentifierSource getIdentifierSource() {
        IdType idType = this.getEntityClass().getIdType();
        switch (idType) {
            case SIMPLE: {
                BasicAttribute attribute = this.getEntityClass().getIdAttributes().iterator().next();
                return new SimpleIdentifierSourceImpl(attribute, this.getEntityClass().getAttributeOverrideMap());
            }
            case COMPOSED: {
                throw new NotYetImplementedException("Composed ids must still be implemented.");
            }
            case EMBEDDED: {
                throw new NotYetImplementedException("Embedded ids must still be implemented.");
            }
        }
        throw new AssertionFailure("The root entity needs to specify an identifier");
    }

    @Override
    public SingularAttributeSource getVersioningAttributeSource() {
        SingularAttributeSourceImpl attributeSource = null;
        EntityClass entityClass = this.getEntityClass();
        if (entityClass.getVersionAttribute() != null) {
            attributeSource = new SingularAttributeSourceImpl(entityClass.getVersionAttribute());
        }
        return attributeSource;
    }

    @Override
    public DiscriminatorSource getDiscriminatorSource() {
        DiscriminatorSourceImpl discriminatorSource = null;
        if (this.getEntityClass().getDiscriminatorColumnValues() != null) {
            discriminatorSource = new DiscriminatorSourceImpl(this.getEntityClass());
        }
        return discriminatorSource;
    }

    @Override
    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public boolean isMutable() {
        return this.getEntityClass().isMutable();
    }

    @Override
    public boolean isExplicitPolymorphism() {
        return this.getEntityClass().isExplicitPolymorphism();
    }

    @Override
    public String getWhere() {
        return this.getEntityClass().getWhereClause();
    }

    @Override
    public String getRowId() {
        return this.getEntityClass().getRowId();
    }

    @Override
    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.getEntityClass().getOptimisticLockStyle();
    }

    @Override
    public Caching getCaching() {
        return this.getEntityClass().getCaching();
    }
}

