/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.global;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.AnnotationException;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.metamodel.binding.TypeDef;
import org.evosuite.shaded.org.hibernate.metamodel.source.MetadataImplementor;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JandexHelper;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class TypeDefBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TypeDefBinder.class.getName());

    public static void bind(AnnotationBindingContext bindingContext) {
        Collection annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.TYPE_DEF);
        for (AnnotationInstance typeDef : annotations) {
            TypeDefBinder.bind(bindingContext.getMetadataImplementor(), typeDef);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.TYPE_DEFS);
        for (AnnotationInstance typeDefs : annotations) {
            AnnotationInstance[] typeDefAnnotations;
            for (AnnotationInstance typeDef : typeDefAnnotations = JandexHelper.getValue(typeDefs, "value", AnnotationInstance[].class)) {
                TypeDefBinder.bind(bindingContext.getMetadataImplementor(), typeDef);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance typeDefAnnotation) {
        AnnotationInstance[] parameterAnnotations;
        boolean noDefaultForType;
        String name = JandexHelper.getValue(typeDefAnnotation, "name", String.class);
        String defaultForType = JandexHelper.getValue(typeDefAnnotation, "defaultForType", String.class);
        String typeClass = JandexHelper.getValue(typeDefAnnotation, "typeClass", String.class);
        boolean noName = StringHelper.isEmpty(name);
        boolean bl = noDefaultForType = defaultForType == null || defaultForType.equals(Void.TYPE.getName());
        if (noName && noDefaultForType) {
            throw new AnnotationException("Either name or defaultForType (or both) attribute should be set in TypeDef having typeClass " + typeClass);
        }
        HashMap<String, String> parameterMaps = new HashMap<String, String>();
        for (AnnotationInstance parameterAnnotation : parameterAnnotations = JandexHelper.getValue(typeDefAnnotation, "parameters", AnnotationInstance[].class)) {
            parameterMaps.put(JandexHelper.getValue(parameterAnnotation, "name", String.class), JandexHelper.getValue(parameterAnnotation, "value", String.class));
        }
        if (!noName) {
            TypeDefBinder.bind(name, typeClass, parameterMaps, metadata);
        }
        if (!noDefaultForType) {
            TypeDefBinder.bind(defaultForType, typeClass, parameterMaps, metadata);
        }
    }

    private static void bind(String name, String typeClass, Map<String, String> prms, MetadataImplementor metadata) {
        LOG.debugf("Binding type definition: %s", (Object)name);
        metadata.addTypeDefinition(new TypeDef(name, typeClass, prms));
    }

    private TypeDefBinder() {
    }
}

