/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.xml.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.xml.filter.IndexedAnnotationFilter;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;
import org.evosuite.shaded.org.jboss.jandex.DotName;

abstract class AbstractAnnotationFilter
implements IndexedAnnotationFilter {
    protected static final DotName[] EMPTY_DOTNAME_ARRAY = new DotName[0];
    private Set<DotName> candidates;

    AbstractAnnotationFilter() {
    }

    private boolean match(DotName annName) {
        if (this.candidates == null) {
            this.candidates = new HashSet<DotName>();
            this.candidates.addAll(Arrays.asList(this.targetAnnotation()));
        }
        return this.candidates.contains(annName);
    }

    @Override
    public void beforePush(IndexBuilder indexBuilder, DotName classDotName, AnnotationInstance annotationInstance) {
        DotName annName = annotationInstance.name();
        if (!this.match(annName)) {
            return;
        }
        Map<DotName, List<AnnotationInstance>> map = indexBuilder.getIndexedAnnotations(classDotName);
        this.overrideIndexedAnnotationMap(annName, annotationInstance, map);
    }

    protected void overrideIndexedAnnotationMap(DotName annName, AnnotationInstance annotationInstance, Map<DotName, List<AnnotationInstance>> map) {
        if (!map.containsKey(annName)) {
            return;
        }
        List<AnnotationInstance> indexedAnnotationInstanceList = map.get(annName);
        if (indexedAnnotationInstanceList.isEmpty()) {
            return;
        }
        this.process(annName, annotationInstance, indexedAnnotationInstanceList);
    }

    protected void process(DotName annName, AnnotationInstance annotationInstance, List<AnnotationInstance> indexedAnnotationInstanceList) {
    }

    protected DotName[] targetAnnotation() {
        return EMPTY_DOTNAME_ARRAY;
    }
}

