/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbAttributes;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbEntity;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbEntityMappings;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbId;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbNamedNativeQuery;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbNamedQuery;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbSequenceGenerator;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbSqlResultSetMapping;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.orm.JaxbTableGenerator;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.metamodel.source.MappingException;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.JPADotNames;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.evosuite.shaded.org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;
import org.evosuite.shaded.org.jboss.jandex.AnnotationValue;
import org.evosuite.shaded.org.jboss.jandex.DotName;
import org.evosuite.shaded.org.jboss.logging.Logger;

class GlobalAnnotations
implements JPADotNames {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, GlobalAnnotations.class.getName());
    private Map<String, JaxbSequenceGenerator> sequenceGeneratorMap = new HashMap<String, JaxbSequenceGenerator>();
    private Map<String, JaxbTableGenerator> tableGeneratorMap = new HashMap<String, JaxbTableGenerator>();
    private Map<String, JaxbNamedQuery> namedQueryMap = new HashMap<String, JaxbNamedQuery>();
    private Map<String, JaxbNamedNativeQuery> namedNativeQueryMap = new HashMap<String, JaxbNamedNativeQuery>();
    private Map<String, JaxbSqlResultSetMapping> sqlResultSetMappingMap = new HashMap<String, JaxbSqlResultSetMapping>();
    private Map<DotName, List<AnnotationInstance>> annotationInstanceMap = new HashMap<DotName, List<AnnotationInstance>>();
    private List<AnnotationInstance> indexedAnnotationInstanceList = new ArrayList<AnnotationInstance>();
    private Set<String> defaultNamedNativeQueryNames = new HashSet<String>();
    private Set<String> defaultNamedQueryNames = new HashSet<String>();
    private Set<String> defaultNamedGenerators = new HashSet<String>();
    private Set<String> defaultSqlResultSetMappingNames = new HashSet<String>();

    GlobalAnnotations() {
    }

    Map<DotName, List<AnnotationInstance>> getAnnotationInstanceMap() {
        return this.annotationInstanceMap;
    }

    AnnotationInstance push(DotName name, AnnotationInstance annotationInstance) {
        if (name == null || annotationInstance == null) {
            return null;
        }
        List<AnnotationInstance> list = this.annotationInstanceMap.get(name);
        if (list == null) {
            list = new ArrayList<AnnotationInstance>();
            this.annotationInstanceMap.put(name, list);
        }
        list.add(annotationInstance);
        return annotationInstance;
    }

    void addIndexedAnnotationInstance(List<AnnotationInstance> annotationInstanceList) {
        if (MockHelper.isNotEmpty(annotationInstanceList)) {
            this.indexedAnnotationInstanceList.addAll(annotationInstanceList);
        }
    }

    boolean hasGlobalConfiguration() {
        return !this.namedQueryMap.isEmpty() || !this.namedNativeQueryMap.isEmpty() || !this.sequenceGeneratorMap.isEmpty() || !this.tableGeneratorMap.isEmpty() || !this.sqlResultSetMappingMap.isEmpty();
    }

    Map<String, JaxbNamedNativeQuery> getNamedNativeQueryMap() {
        return this.namedNativeQueryMap;
    }

    Map<String, JaxbNamedQuery> getNamedQueryMap() {
        return this.namedQueryMap;
    }

    Map<String, JaxbSequenceGenerator> getSequenceGeneratorMap() {
        return this.sequenceGeneratorMap;
    }

    Map<String, JaxbSqlResultSetMapping> getSqlResultSetMappingMap() {
        return this.sqlResultSetMappingMap;
    }

    Map<String, JaxbTableGenerator> getTableGeneratorMap() {
        return this.tableGeneratorMap;
    }

    public void filterIndexedAnnotations() {
        for (AnnotationInstance annotationInstance : this.indexedAnnotationInstanceList) {
            this.pushIfNotExist(annotationInstance);
        }
    }

    private void pushIfNotExist(AnnotationInstance annotationInstance) {
        DotName annName = annotationInstance.name();
        boolean isNotExist = false;
        if (annName.equals(SQL_RESULT_SET_MAPPINGS)) {
            AnnotationInstance[] annotationInstances;
            for (AnnotationInstance ai : annotationInstances = annotationInstance.value().asNestedArray()) {
                this.pushIfNotExist(ai);
            }
        } else {
            AnnotationValue value = annotationInstance.value("name");
            String name = value.asString();
            boolean bl = isNotExist = annName.equals(TABLE_GENERATOR) && !this.tableGeneratorMap.containsKey(name) || annName.equals(SEQUENCE_GENERATOR) && !this.sequenceGeneratorMap.containsKey(name) || annName.equals(NAMED_QUERY) && !this.namedQueryMap.containsKey(name) || annName.equals(NAMED_NATIVE_QUERY) && !this.namedNativeQueryMap.containsKey(name) || annName.equals(SQL_RESULT_SET_MAPPING) && !this.sqlResultSetMappingMap.containsKey(name);
        }
        if (isNotExist) {
            this.push(annName, annotationInstance);
        }
    }

    void collectGlobalMappings(JaxbEntityMappings entityMappings, EntityMappingsMocker.Default defaults) {
        for (JaxbSequenceGenerator jaxbSequenceGenerator : entityMappings.getSequenceGenerator()) {
            this.put(jaxbSequenceGenerator, defaults);
            this.defaultNamedGenerators.add(jaxbSequenceGenerator.getName());
        }
        for (JaxbTableGenerator jaxbTableGenerator : entityMappings.getTableGenerator()) {
            this.put(jaxbTableGenerator, defaults);
            this.defaultNamedGenerators.add(jaxbTableGenerator.getName());
        }
        for (JaxbNamedQuery jaxbNamedQuery : entityMappings.getNamedQuery()) {
            this.put(jaxbNamedQuery);
            this.defaultNamedQueryNames.add(jaxbNamedQuery.getName());
        }
        for (JaxbNamedNativeQuery jaxbNamedNativeQuery : entityMappings.getNamedNativeQuery()) {
            this.put(jaxbNamedNativeQuery);
            this.defaultNamedNativeQueryNames.add(jaxbNamedNativeQuery.getName());
        }
        for (JaxbSqlResultSetMapping jaxbSqlResultSetMapping : entityMappings.getSqlResultSetMapping()) {
            this.put(jaxbSqlResultSetMapping);
            this.defaultSqlResultSetMappingNames.add(jaxbSqlResultSetMapping.getName());
        }
    }

    void collectGlobalMappings(JaxbEntity entity, EntityMappingsMocker.Default defaults) {
        JaxbAttributes attributes;
        JaxbTableGenerator tableGenerator;
        for (JaxbNamedQuery namedQuery : entity.getNamedQuery()) {
            if (!this.defaultNamedQueryNames.contains(namedQuery.getName())) {
                this.put(namedQuery);
                continue;
            }
            LOG.warn("Named Query [" + namedQuery.getName() + "] duplicated.");
        }
        for (JaxbNamedNativeQuery namedNativeQuery : entity.getNamedNativeQuery()) {
            if (!this.defaultNamedNativeQueryNames.contains(namedNativeQuery.getName())) {
                this.put(namedNativeQuery);
                continue;
            }
            LOG.warn("Named native Query [" + namedNativeQuery.getName() + "] duplicated.");
        }
        for (JaxbSqlResultSetMapping sqlResultSetMapping : entity.getSqlResultSetMapping()) {
            if (this.defaultSqlResultSetMappingNames.contains(sqlResultSetMapping.getName())) continue;
            this.put(sqlResultSetMapping);
        }
        JaxbSequenceGenerator sequenceGenerator = entity.getSequenceGenerator();
        if (sequenceGenerator != null && !this.defaultNamedGenerators.contains(sequenceGenerator.getName())) {
            this.put(sequenceGenerator, defaults);
        }
        if ((tableGenerator = entity.getTableGenerator()) != null && !this.defaultNamedGenerators.contains(tableGenerator.getName())) {
            this.put(tableGenerator, defaults);
        }
        if ((attributes = entity.getAttributes()) != null) {
            for (JaxbId id : attributes.getId()) {
                sequenceGenerator = id.getSequenceGenerator();
                if (sequenceGenerator != null) {
                    this.put(sequenceGenerator, defaults);
                }
                if ((tableGenerator = id.getTableGenerator()) == null) continue;
                this.put(tableGenerator, defaults);
            }
        }
    }

    private static JaxbSequenceGenerator overrideGenerator(JaxbSequenceGenerator generator, EntityMappingsMocker.Default defaults) {
        if (StringHelper.isEmpty(generator.getSchema()) && defaults != null) {
            generator.setSchema(defaults.getSchema());
        }
        if (StringHelper.isEmpty(generator.getCatalog()) && defaults != null) {
            generator.setCatalog(defaults.getCatalog());
        }
        return generator;
    }

    private static JaxbTableGenerator overrideGenerator(JaxbTableGenerator generator, EntityMappingsMocker.Default defaults) {
        if (StringHelper.isEmpty(generator.getSchema()) && defaults != null) {
            generator.setSchema(defaults.getSchema());
        }
        if (StringHelper.isEmpty(generator.getCatalog()) && defaults != null) {
            generator.setCatalog(defaults.getCatalog());
        }
        return generator;
    }

    private void put(JaxbNamedNativeQuery query) {
        if (query != null) {
            this.checkQueryName(query.getName());
            this.namedNativeQueryMap.put(query.getName(), query);
        }
    }

    private void checkQueryName(String name) {
        if (this.namedQueryMap.containsKey(name) || this.namedNativeQueryMap.containsKey(name)) {
            throw new MappingException("Duplicated query mapping " + name, null);
        }
    }

    private void put(JaxbNamedQuery query) {
        if (query != null) {
            this.checkQueryName(query.getName());
            this.namedQueryMap.put(query.getName(), query);
        }
    }

    private void put(JaxbSequenceGenerator generator, EntityMappingsMocker.Default defaults) {
        JaxbSequenceGenerator old;
        if (generator != null && (old = this.sequenceGeneratorMap.put(generator.getName(), GlobalAnnotations.overrideGenerator(generator, defaults))) != null) {
            LOG.duplicateGeneratorName(generator.getName());
        }
    }

    private void put(JaxbTableGenerator generator, EntityMappingsMocker.Default defaults) {
        JaxbTableGenerator old;
        if (generator != null && (old = this.tableGeneratorMap.put(generator.getName(), GlobalAnnotations.overrideGenerator(generator, defaults))) != null) {
            LOG.duplicateGeneratorName(generator.getName());
        }
    }

    private void put(JaxbSqlResultSetMapping mapping) {
        JaxbSqlResultSetMapping old;
        if (mapping != null && (old = this.sqlResultSetMappingMap.put(mapping.getName(), mapping)) != null) {
            throw new MappingException("Duplicated SQL result set mapping " + mapping.getName(), null);
        }
    }
}

