/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.EntityMode;
import org.evosuite.shaded.org.hibernate.internal.jaxb.Origin;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.EntityElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbAnyElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbBagElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbComponentElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbIdbagElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbListElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToOneElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbMapElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbOneToOneElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbPropertyElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbSetElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbSynchronizeElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbTuplizerElement;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CustomSQL;
import org.evosuite.shaded.org.hibernate.metamodel.source.LocalBindingContext;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.AttributeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.ConstraintSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.EntitySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.SubclassEntitySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.TableSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.BagAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.ComponentAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.EntityHierarchyImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.Helper;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.ManyToOneAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.MappingDocument;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.PropertyAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.SetAttributeSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.SubclassEntitySourceImpl;

public abstract class AbstractEntitySourceImpl
implements EntitySource {
    private final MappingDocument sourceMappingDocument;
    private final EntityElement entityElement;
    private List<SubclassEntitySource> subclassEntitySources = new ArrayList<SubclassEntitySource>();
    private EntityHierarchyImpl entityHierarchy;

    protected AbstractEntitySourceImpl(MappingDocument sourceMappingDocument, EntityElement entityElement) {
        this.sourceMappingDocument = sourceMappingDocument;
        this.entityElement = entityElement;
    }

    protected EntityElement entityElement() {
        return this.entityElement;
    }

    protected MappingDocument sourceMappingDocument() {
        return this.sourceMappingDocument;
    }

    @Override
    public Origin getOrigin() {
        return this.sourceMappingDocument.getOrigin();
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.sourceMappingDocument.getMappingLocalBindingContext();
    }

    @Override
    public String getEntityName() {
        return StringHelper.isNotEmpty(this.entityElement.getEntityName()) ? this.entityElement.getEntityName() : this.getClassName();
    }

    @Override
    public String getClassName() {
        return this.getLocalBindingContext().qualifyClassName(this.entityElement.getName());
    }

    @Override
    public String getJpaEntityName() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return Helper.getBooleanValue(this.entityElement.isAbstract(), false);
    }

    @Override
    public boolean isLazy() {
        return Helper.getBooleanValue(this.entityElement.isAbstract(), true);
    }

    @Override
    public String getProxy() {
        return this.entityElement.getProxy();
    }

    @Override
    public int getBatchSize() {
        return Helper.getIntValue(this.entityElement.getBatchSize(), -1);
    }

    @Override
    public boolean isDynamicInsert() {
        return this.entityElement.isDynamicInsert();
    }

    @Override
    public boolean isDynamicUpdate() {
        return this.entityElement.isDynamicUpdate();
    }

    @Override
    public boolean isSelectBeforeUpdate() {
        return this.entityElement.isSelectBeforeUpdate();
    }

    protected EntityMode determineEntityMode() {
        return StringHelper.isNotEmpty(this.getClassName()) ? EntityMode.POJO : EntityMode.MAP;
    }

    @Override
    public String getCustomTuplizerClassName() {
        if (this.entityElement.getTuplizer() == null) {
            return null;
        }
        EntityMode entityMode = this.determineEntityMode();
        for (JaxbTuplizerElement tuplizerElement : this.entityElement.getTuplizer()) {
            if (entityMode != EntityMode.parse(tuplizerElement.getEntityMode())) continue;
            return tuplizerElement.getClazz();
        }
        return null;
    }

    @Override
    public String getCustomPersisterClassName() {
        return this.getLocalBindingContext().qualifyClassName(this.entityElement.getPersister());
    }

    @Override
    public String getCustomLoaderName() {
        return this.entityElement.getLoader() != null ? this.entityElement.getLoader().getQueryRef() : null;
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return Helper.buildCustomSql(this.entityElement.getSqlInsert());
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return Helper.buildCustomSql(this.entityElement.getSqlUpdate());
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return Helper.buildCustomSql(this.entityElement.getSqlDelete());
    }

    @Override
    public List<String> getSynchronizedTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (JaxbSynchronizeElement synchronizeElement : this.entityElement.getSynchronize()) {
            tableNames.add(synchronizeElement.getTable());
        }
        return tableNames;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.entityElement.getMeta());
    }

    @Override
    public String getPath() {
        return this.sourceMappingDocument.getMappingLocalBindingContext().determineEntityName(this.entityElement);
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> attributeSources = new ArrayList<AttributeSource>();
        for (Object attributeElement : this.entityElement.getPropertyOrManyToOneOrOneToOne()) {
            if (JaxbPropertyElement.class.isInstance(attributeElement)) {
                attributeSources.add(new PropertyAttributeSourceImpl((JaxbPropertyElement)JaxbPropertyElement.class.cast(attributeElement), this.sourceMappingDocument().getMappingLocalBindingContext()));
                continue;
            }
            if (JaxbComponentElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ComponentAttributeSourceImpl((JaxbComponentElement)attributeElement, this, this.sourceMappingDocument.getMappingLocalBindingContext()));
                continue;
            }
            if (JaxbManyToOneElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ManyToOneAttributeSourceImpl((JaxbManyToOneElement)JaxbManyToOneElement.class.cast(attributeElement), this.sourceMappingDocument().getMappingLocalBindingContext()));
                continue;
            }
            if (JaxbOneToOneElement.class.isInstance(attributeElement) || JaxbAnyElement.class.isInstance(attributeElement)) continue;
            if (JaxbBagElement.class.isInstance(attributeElement)) {
                attributeSources.add(new BagAttributeSourceImpl((JaxbBagElement)JaxbBagElement.class.cast(attributeElement), (AttributeSourceContainer)this));
                continue;
            }
            if (JaxbIdbagElement.class.isInstance(attributeElement)) continue;
            if (JaxbSetElement.class.isInstance(attributeElement)) {
                attributeSources.add(new SetAttributeSourceImpl((JaxbSetElement)JaxbSetElement.class.cast(attributeElement), (AttributeSourceContainer)this));
                continue;
            }
            if (JaxbListElement.class.isInstance(attributeElement) || JaxbMapElement.class.isInstance(attributeElement)) continue;
            throw new AssertionFailure("Unexpected attribute element type encountered : " + attributeElement.getClass());
        }
        return attributeSources;
    }

    public void injectHierarchy(EntityHierarchyImpl entityHierarchy) {
        this.entityHierarchy = entityHierarchy;
    }

    @Override
    public void add(SubclassEntitySource subclassEntitySource) {
        this.add((SubclassEntitySourceImpl)subclassEntitySource);
    }

    public void add(SubclassEntitySourceImpl subclassEntitySource) {
        this.entityHierarchy.processSubclass(subclassEntitySource);
        this.subclassEntitySources.add(subclassEntitySource);
    }

    @Override
    public Iterable<SubclassEntitySource> subclassEntitySources() {
        return this.subclassEntitySources;
    }

    @Override
    public String getDiscriminatorMatchValue() {
        return null;
    }

    @Override
    public Iterable<ConstraintSource> getConstraints() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<TableSource> getSecondaryTables() {
        return Collections.emptySet();
    }

    @Override
    public List<JpaCallbackClass> getJpaCallbackClasses() {
        return Collections.EMPTY_LIST;
    }
}

