/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.hbm;

import java.util.Collections;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.FetchMode;
import org.evosuite.shaded.org.hibernate.cache.spi.access.AccessType;
import org.evosuite.shaded.org.hibernate.cfg.NotYetImplementedException;
import org.evosuite.shaded.org.hibernate.engine.FetchStyle;
import org.evosuite.shaded.org.hibernate.engine.FetchTiming;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadeStyle;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbCacheElement;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.PluralAttributeElement;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.metamodel.binding.Caching;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CustomSQL;
import org.evosuite.shaded.org.hibernate.metamodel.source.LocalBindingContext;
import org.evosuite.shaded.org.hibernate.metamodel.source.MappingException;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.PluralAttributeElementSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.PluralAttributeKeySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.PluralAttributeSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.BasicPluralAttributeElementSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.CompositePluralAttributeElementSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.Helper;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.ManyToManyPluralAttributeElementSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.OneToManyPluralAttributeElementSourceImpl;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.PluralAttributeKeySourceImpl;

public abstract class AbstractPluralAttributeSourceImpl
implements PluralAttributeSource {
    private final PluralAttributeElement pluralAttributeElement;
    private final AttributeSourceContainer container;
    private final ExplicitHibernateTypeSource typeInformation;
    private final PluralAttributeKeySource keySource;
    private final PluralAttributeElementSource elementSource;

    protected AbstractPluralAttributeSourceImpl(final PluralAttributeElement pluralAttributeElement, AttributeSourceContainer container) {
        this.pluralAttributeElement = pluralAttributeElement;
        this.container = container;
        this.keySource = new PluralAttributeKeySourceImpl(pluralAttributeElement.getKey(), container);
        this.elementSource = this.interpretElementType();
        this.typeInformation = new ExplicitHibernateTypeSource(){

            @Override
            public String getName() {
                return pluralAttributeElement.getCollectionType();
            }

            @Override
            public Map<String, String> getParameters() {
                return Collections.emptyMap();
            }
        };
    }

    private PluralAttributeElementSource interpretElementType() {
        if (this.pluralAttributeElement.getElement() != null) {
            return new BasicPluralAttributeElementSourceImpl(this.pluralAttributeElement.getElement(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getCompositeElement() != null) {
            return new CompositePluralAttributeElementSourceImpl(this.pluralAttributeElement.getCompositeElement(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getOneToMany() != null) {
            return new OneToManyPluralAttributeElementSourceImpl(this.pluralAttributeElement.getOneToMany(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getManyToMany() != null) {
            return new ManyToManyPluralAttributeElementSourceImpl(this.pluralAttributeElement.getManyToMany(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getManyToAny() != null) {
            throw new NotYetImplementedException("Support for many-to-any not yet implemented");
        }
        throw new MappingException("Unexpected collection element type : " + this.pluralAttributeElement.getName(), this.bindingContext().getOrigin());
    }

    public PluralAttributeElement getPluralAttributeElement() {
        return this.pluralAttributeElement;
    }

    protected AttributeSourceContainer container() {
        return this.container;
    }

    protected LocalBindingContext bindingContext() {
        return this.container().getLocalBindingContext();
    }

    @Override
    public PluralAttributeKeySource getKeySource() {
        return this.keySource;
    }

    @Override
    public PluralAttributeElementSource getElementSource() {
        return this.elementSource;
    }

    @Override
    public String getExplicitSchemaName() {
        return this.pluralAttributeElement.getSchema();
    }

    @Override
    public String getExplicitCatalogName() {
        return this.pluralAttributeElement.getCatalog();
    }

    @Override
    public String getExplicitCollectionTableName() {
        return this.pluralAttributeElement.getTable();
    }

    @Override
    public String getCollectionTableComment() {
        return this.pluralAttributeElement.getComment();
    }

    @Override
    public String getCollectionTableCheck() {
        return this.pluralAttributeElement.getCheck();
    }

    @Override
    public Caching getCaching() {
        JaxbCacheElement cache = this.pluralAttributeElement.getCache();
        if (cache == null) {
            return null;
        }
        String region = cache.getRegion() != null ? cache.getRegion() : StringHelper.qualify(this.container().getPath(), this.getName());
        AccessType accessType = Enum.valueOf(AccessType.class, cache.getUsage());
        boolean cacheLazyProps = !"non-lazy".equals(cache.getInclude());
        return new Caching(region, accessType, cacheLazyProps);
    }

    @Override
    public String getWhere() {
        return this.pluralAttributeElement.getWhere();
    }

    @Override
    public String getName() {
        return this.pluralAttributeElement.getName();
    }

    @Override
    public boolean isSingular() {
        return false;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.pluralAttributeElement.getAccess();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.pluralAttributeElement.isOptimisticLock();
    }

    @Override
    public boolean isInverse() {
        return this.pluralAttributeElement.isInverse();
    }

    @Override
    public String getCustomPersisterClassName() {
        return this.pluralAttributeElement.getPersister();
    }

    @Override
    public String getCustomLoaderName() {
        return this.pluralAttributeElement.getLoader() == null ? null : this.pluralAttributeElement.getLoader().getQueryRef();
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlInsert());
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlUpdate());
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlDelete());
    }

    @Override
    public CustomSQL getCustomSqlDeleteAll() {
        return Helper.buildCustomSql(this.pluralAttributeElement.getSqlDeleteAll());
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.pluralAttributeElement.getMeta());
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return Helper.interpretCascadeStyles(this.pluralAttributeElement.getCascade(), this.bindingContext());
    }

    @Override
    public FetchTiming getFetchTiming() {
        String outerJoinSelection;
        String fetchSelection = this.pluralAttributeElement.getFetch() != null ? this.pluralAttributeElement.getFetch().value() : null;
        String lazySelection = this.pluralAttributeElement.getLazy() != null ? this.pluralAttributeElement.getLazy().value() : null;
        String string = outerJoinSelection = this.pluralAttributeElement.getOuterJoin() != null ? this.pluralAttributeElement.getOuterJoin().value() : null;
        if (lazySelection == null) {
            if ("join".equals(fetchSelection) || "true".equals(outerJoinSelection)) {
                return FetchTiming.IMMEDIATE;
            }
            if ("false".equals(outerJoinSelection)) {
                return FetchTiming.DELAYED;
            }
            return this.bindingContext().getMappingDefaults().areAssociationsLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
        }
        if ("extra".equals(lazySelection)) {
            return FetchTiming.EXTRA_LAZY;
        }
        if ("true".equals(lazySelection)) {
            return FetchTiming.DELAYED;
        }
        if ("false".equals(lazySelection)) {
            return FetchTiming.IMMEDIATE;
        }
        throw new MappingException(String.format("Unexpected lazy selection [%s] on '%s'", lazySelection, this.pluralAttributeElement.getName()), this.bindingContext().getOrigin());
    }

    @Override
    public FetchStyle getFetchStyle() {
        String fetchSelection = this.pluralAttributeElement.getFetch() != null ? this.pluralAttributeElement.getFetch().value() : null;
        String outerJoinSelection = this.pluralAttributeElement.getOuterJoin() != null ? this.pluralAttributeElement.getOuterJoin().value() : null;
        int batchSize = Helper.getIntValue(this.pluralAttributeElement.getBatchSize(), -1);
        if (fetchSelection == null) {
            if (outerJoinSelection == null) {
                return batchSize > 1 ? FetchStyle.BATCH : FetchStyle.SELECT;
            }
            if ("auto".equals(outerJoinSelection)) {
                return this.bindingContext().getMappingDefaults().areAssociationsLazy() ? FetchStyle.SELECT : FetchStyle.JOIN;
            }
            return "true".equals(outerJoinSelection) ? FetchStyle.JOIN : FetchStyle.SELECT;
        }
        if ("subselect".equals(fetchSelection)) {
            return FetchStyle.SUBSELECT;
        }
        return "join".equals(fetchSelection) ? FetchStyle.JOIN : FetchStyle.SELECT;
    }

    @Override
    public FetchMode getFetchMode() {
        return this.pluralAttributeElement.getFetch() == null ? FetchMode.DEFAULT : FetchMode.valueOf(this.pluralAttributeElement.getFetch().value());
    }
}

