/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.hbm;

import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbColumnElement;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Datatype;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Size;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.ColumnSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.Helper;

class ColumnSourceImpl
implements ColumnSource {
    private final String tableName;
    private final JaxbColumnElement columnElement;
    private boolean includedInInsert;
    private boolean includedInUpdate;
    private final boolean isForceNotNull;

    ColumnSourceImpl(String tableName, JaxbColumnElement columnElement, boolean isIncludedInInsert, boolean isIncludedInUpdate) {
        this(tableName, columnElement, isIncludedInInsert, isIncludedInUpdate, false);
    }

    ColumnSourceImpl(String tableName, JaxbColumnElement columnElement, boolean isIncludedInInsert, boolean isIncludedInUpdate, boolean isForceNotNull) {
        this.tableName = tableName;
        this.columnElement = columnElement;
        this.isForceNotNull = isForceNotNull;
        this.includedInInsert = isIncludedInInsert;
        this.includedInUpdate = isIncludedInUpdate;
    }

    @Override
    public String getName() {
        return this.columnElement.getName();
    }

    @Override
    public boolean isNullable() {
        if (this.isForceNotNull) {
            return false;
        }
        return this.columnElement.isNotNull() == false;
    }

    @Override
    public String getDefaultValue() {
        return this.columnElement.getDefault();
    }

    @Override
    public String getSqlType() {
        return this.columnElement.getSqlType();
    }

    @Override
    public Datatype getDatatype() {
        return null;
    }

    @Override
    public Size getSize() {
        return new Size(Helper.getIntValue(this.columnElement.getPrecision(), -1), Helper.getIntValue(this.columnElement.getScale(), -1), Helper.getLongValue(this.columnElement.getLength(), -1L), Size.LobMultiplier.NONE);
    }

    @Override
    public String getReadFragment() {
        return this.columnElement.getRead();
    }

    @Override
    public String getWriteFragment() {
        return this.columnElement.getWrite();
    }

    @Override
    public boolean isUnique() {
        return this.columnElement.isUnique();
    }

    @Override
    public String getCheckCondition() {
        return this.columnElement.getCheck();
    }

    @Override
    public String getComment() {
        return this.columnElement.getComment();
    }

    @Override
    public boolean isIncludedInInsert() {
        return this.includedInInsert;
    }

    @Override
    public boolean isIncludedInUpdate() {
        return this.includedInUpdate;
    }

    @Override
    public String getContainingTableName() {
        return this.tableName;
    }
}

