/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.hbm;

import java.util.List;
import org.evosuite.shaded.org.hibernate.internal.jaxb.mapping.hbm.JaxbKeyElement;
import org.evosuite.shaded.org.hibernate.metamodel.relational.ForeignKey;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.PluralAttributeKeySource;
import org.evosuite.shaded.org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.evosuite.shaded.org.hibernate.metamodel.source.hbm.Helper;

public class PluralAttributeKeySourceImpl
implements PluralAttributeKeySource {
    private final JaxbKeyElement keyElement;
    private final List<RelationalValueSource> valueSources;

    public PluralAttributeKeySourceImpl(final JaxbKeyElement keyElement, AttributeSourceContainer container) {
        this.keyElement = keyElement;
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            @Override
            public String getContainingTableName() {
                return null;
            }

            @Override
            public boolean isIncludedInInsertByDefault() {
                return true;
            }

            @Override
            public boolean isIncludedInUpdateByDefault() {
                return Helper.getBooleanValue(keyElement.isUpdate(), true);
            }

            @Override
            public String getColumnAttribute() {
                return keyElement.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List getColumnOrFormulaElements() {
                return keyElement.getColumn();
            }
        }, container.getLocalBindingContext());
    }

    @Override
    public List<RelationalValueSource> getValueSources() {
        return this.valueSources;
    }

    @Override
    public String getExplicitForeignKeyName() {
        return this.keyElement.getForeignKey();
    }

    @Override
    public ForeignKey.ReferentialAction getOnDeleteAction() {
        return "cascade".equals(this.keyElement.getOnDelete()) ? ForeignKey.ReferentialAction.CASCADE : ForeignKey.ReferentialAction.NO_ACTION;
    }

    @Override
    public String getReferencedEntityAttributeName() {
        return this.keyElement.getPropertyRef();
    }
}

