/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.internal;

import javax.persistence.SharedCacheMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.evosuite.shaded.org.hibernate.boot.registry.StandardServiceRegistry;
import org.evosuite.shaded.org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.evosuite.shaded.org.hibernate.cache.spi.access.AccessType;
import org.evosuite.shaded.org.hibernate.cfg.EJB3NamingStrategy;
import org.evosuite.shaded.org.hibernate.cfg.NamingStrategy;
import org.evosuite.shaded.org.hibernate.engine.config.spi.ConfigurationService;
import org.evosuite.shaded.org.hibernate.metamodel.Metadata;
import org.evosuite.shaded.org.hibernate.metamodel.MetadataBuilder;
import org.evosuite.shaded.org.hibernate.metamodel.MetadataSourceProcessingOrder;
import org.evosuite.shaded.org.hibernate.metamodel.MetadataSources;
import org.evosuite.shaded.org.hibernate.metamodel.source.internal.MetadataImpl;
import org.evosuite.shaded.org.hibernate.service.ServiceRegistry;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class MetadataBuilderImpl
implements MetadataBuilder {
    private static final Logger log = Logger.getLogger(MetadataBuilderImpl.class);
    private final MetadataSources sources;
    private final OptionsImpl options;

    public MetadataBuilderImpl(MetadataSources sources) {
        this(sources, MetadataBuilderImpl.getStandardServiceRegistry(sources.getServiceRegistry()));
    }

    private static StandardServiceRegistry getStandardServiceRegistry(ServiceRegistry serviceRegistry) {
        if (serviceRegistry == null) {
            throw new HibernateException("ServiceRegistry passed to MetadataBuilder cannot be null");
        }
        if (StandardServiceRegistry.class.isInstance(serviceRegistry)) {
            return (StandardServiceRegistry)serviceRegistry;
        }
        if (BootstrapServiceRegistry.class.isInstance(serviceRegistry)) {
            log.debugf("ServiceRegistry passed to MetadataBuilder was a BootstrapServiceRegistry; this likely wont end wellif attempt is made to build SessionFactory", new Object[0]);
            return new StandardServiceRegistryBuilder((BootstrapServiceRegistry)serviceRegistry).build();
        }
        throw new HibernateException(String.format("Unexpected type of ServiceRegistry [%s] encountered in attempt to build MetadataBuilder", serviceRegistry.getClass().getName()));
    }

    public MetadataBuilderImpl(MetadataSources sources, StandardServiceRegistry serviceRegistry) {
        this.sources = sources;
        this.options = new OptionsImpl(serviceRegistry);
    }

    @Override
    public MetadataBuilder with(NamingStrategy namingStrategy) {
        this.options.namingStrategy = namingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder with(MetadataSourceProcessingOrder metadataSourceProcessingOrder) {
        this.options.metadataSourceProcessingOrder = metadataSourceProcessingOrder;
        return this;
    }

    @Override
    public MetadataBuilder with(SharedCacheMode sharedCacheMode) {
        this.options.sharedCacheMode = sharedCacheMode;
        return this;
    }

    @Override
    public MetadataBuilder with(AccessType accessType) {
        this.options.defaultCacheAccessType = accessType;
        return this;
    }

    @Override
    public MetadataBuilder withNewIdentifierGeneratorsEnabled(boolean enabled) {
        this.options.useNewIdentifierGenerators = enabled;
        return this;
    }

    @Override
    public Metadata build() {
        return new MetadataImpl(this.sources, this.options);
    }

    public static class OptionsImpl
    implements Metadata.Options {
        private final StandardServiceRegistry serviceRegistry;
        private MetadataSourceProcessingOrder metadataSourceProcessingOrder = MetadataSourceProcessingOrder.HBM_FIRST;
        private NamingStrategy namingStrategy = EJB3NamingStrategy.INSTANCE;
        private SharedCacheMode sharedCacheMode = SharedCacheMode.ENABLE_SELECTIVE;
        private AccessType defaultCacheAccessType;
        private boolean useNewIdentifierGenerators;
        private boolean globallyQuotedIdentifiers;
        private String defaultSchemaName;
        private String defaultCatalogName;

        public OptionsImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            ConfigurationService configService = serviceRegistry.getService(ConfigurationService.class);
            this.defaultCacheAccessType = configService.getSetting("hibernate.cache.default_cache_concurrency_strategy", new ConfigurationService.Converter<AccessType>(){

                @Override
                public AccessType convert(Object value) {
                    return AccessType.fromExternalName(value.toString());
                }
            });
            this.useNewIdentifierGenerators = configService.getSetting("hibernate.id.new_generator_mappings", new ConfigurationService.Converter<Boolean>(){

                @Override
                public Boolean convert(Object value) {
                    return Boolean.parseBoolean(value.toString());
                }
            }, Boolean.valueOf(false));
            this.defaultSchemaName = configService.getSetting("hibernate.default_schema", new ConfigurationService.Converter<String>(){

                @Override
                public String convert(Object value) {
                    return value.toString();
                }
            }, null);
            this.defaultCatalogName = configService.getSetting("hibernate.default_catalog", new ConfigurationService.Converter<String>(){

                @Override
                public String convert(Object value) {
                    return value.toString();
                }
            }, null);
            this.globallyQuotedIdentifiers = configService.getSetting("hibernate.globally_quoted_identifiers", new ConfigurationService.Converter<Boolean>(){

                @Override
                public Boolean convert(Object value) {
                    return Boolean.parseBoolean(value.toString());
                }
            }, Boolean.valueOf(false));
        }

        @Override
        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public MetadataSourceProcessingOrder getMetadataSourceProcessingOrder() {
            return this.metadataSourceProcessingOrder;
        }

        @Override
        public NamingStrategy getNamingStrategy() {
            return this.namingStrategy;
        }

        @Override
        public AccessType getDefaultAccessType() {
            return this.defaultCacheAccessType;
        }

        @Override
        public SharedCacheMode getSharedCacheMode() {
            return this.sharedCacheMode;
        }

        @Override
        public boolean useNewIdentifierGenerators() {
            return this.useNewIdentifierGenerators;
        }

        @Override
        public boolean isGloballyQuotedIdentifiers() {
            return this.globallyQuotedIdentifiers;
        }

        @Override
        public String getDefaultSchemaName() {
            return this.defaultSchemaName;
        }

        @Override
        public String getDefaultCatalogName() {
            return this.defaultCatalogName;
        }
    }
}

