/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.source.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.EmptyInterceptor;
import org.evosuite.shaded.org.hibernate.Interceptor;
import org.evosuite.shaded.org.hibernate.ObjectNotFoundException;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.hibernate.boot.registry.StandardServiceRegistry;
import org.evosuite.shaded.org.hibernate.internal.SessionFactoryImpl;
import org.evosuite.shaded.org.hibernate.metamodel.SessionFactoryBuilder;
import org.evosuite.shaded.org.hibernate.metamodel.source.MetadataImplementor;
import org.evosuite.shaded.org.hibernate.proxy.EntityNotFoundDelegate;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilder {
    SessionFactoryOptionsImpl options;
    private final MetadataImplementor metadata;

    SessionFactoryBuilderImpl(MetadataImplementor metadata) {
        this.metadata = metadata;
        this.options = new SessionFactoryOptionsImpl(metadata.getOptions().getServiceRegistry());
    }

    @Override
    public SessionFactoryBuilder with(Interceptor interceptor) {
        this.options.interceptor = interceptor;
        return this;
    }

    @Override
    public SessionFactoryBuilder with(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.options.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    @Override
    public SessionFactory build() {
        return new SessionFactoryImpl(this.metadata, this.options, null);
    }

    private static class SessionFactoryOptionsImpl
    implements SessionFactory.SessionFactoryOptions {
        private final StandardServiceRegistry serviceRegistry;
        private Interceptor interceptor = EmptyInterceptor.INSTANCE;
        private EntityNotFoundDelegate entityNotFoundDelegate = new EntityNotFoundDelegate(){

            @Override
            public void handleEntityNotFound(String entityName, Serializable id) {
                throw new ObjectNotFoundException(id, entityName);
            }
        };

        public SessionFactoryOptionsImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
        }

        @Override
        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        @Override
        public EntityNotFoundDelegate getEntityNotFoundDelegate() {
            return this.entityNotFoundDelegate;
        }
    }
}

