/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.persister.collection;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.internal.AbstractQueryImpl;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.loader.collection.CollectionInitializer;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.jboss.logging.Logger;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NamedQueryCollectionInitializer.class.getName());
    private final String queryName;
    private final CollectionPersister persister;

    public NamedQueryCollectionInitializer(String queryName, CollectionPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    @Override
    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        LOG.debugf("Initializing collection: %s using named query: %s", (Object)this.persister.getRole(), (Object)this.queryName);
        AbstractQueryImpl query = (AbstractQueryImpl)session.getNamedSQLQuery(this.queryName);
        if (query.getNamedParameters().length > 0) {
            query.setParameter(query.getNamedParameters()[0], (Object)key, this.persister.getKeyType());
        } else {
            query.setParameter(0, (Object)key, this.persister.getKeyType());
        }
        query.setCollectionKey(key).setFlushMode(FlushMode.MANUAL).list();
    }
}

