/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.persister.entity;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.evosuite.shaded.org.dom4j.Node;
import org.evosuite.shaded.org.hibernate.EntityMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.engine.spi.Mapping;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.internal.util.collections.ArrayHelper;
import org.evosuite.shaded.org.hibernate.internal.util.compare.EqualsHelper;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Size;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.persister.entity.Loadable;
import org.evosuite.shaded.org.hibernate.type.AbstractType;
import org.evosuite.shaded.org.hibernate.type.Type;

public class DiscriminatorType
extends AbstractType {
    private final Type underlyingType;
    private final Loadable persister;

    public DiscriminatorType(Type underlyingType, Loadable persister) {
        this.underlyingType = underlyingType;
        this.persister = persister;
    }

    @Override
    public Class getReturnedClass() {
        return Class.class;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0], session, owner);
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object discriminatorValue = this.underlyingType.nullSafeGet(rs, name, session, owner);
        String entityName = this.persister.getSubclassForDiscriminatorValue(discriminatorValue);
        if (entityName == null) {
            throw new HibernateException("Unable to resolve discriminator value [" + discriminatorValue + "] to entity name");
        }
        EntityPersister entityPersister = session.getEntityPersister(entityName, null);
        return EntityMode.POJO == entityPersister.getEntityMode() ? entityPersister.getMappedClass() : entityName;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index, session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        String entityName = session.getFactory().getClassMetadata((Class)value).getEntityName();
        Loadable entityPersister = (Loadable)session.getFactory().getEntityPersister(entityName);
        this.underlyingType.nullSafeSet(st, entityPersister.getDiscriminatorValue(), index, session);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "[null]" : value.toString();
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return original;
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return EqualsHelper.equals(old, current);
    }

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.underlyingType.sqlTypes(mapping);
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return this.underlyingType.dictatedSizes(mapping);
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return this.underlyingType.defaultSizes(mapping);
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.underlyingType.getColumnSpan(mapping);
    }

    @Override
    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
    }

    @Override
    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return null;
    }
}

