/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.persister.entity;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.internal.AbstractQueryImpl;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.loader.entity.UniqueEntityLoader;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(NamedQueryLoader.class);
    private final String queryName;
    private final EntityPersister persister;

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
        if (lockOptions != null) {
            LOG.debug("Ignoring lock-options passed to named query loader");
        }
        return this.load(id, optionalObject, session);
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SessionImplementor session) {
        LOG.debugf("Loading entity: %s using named query: %s", (Object)this.persister.getEntityName(), (Object)this.queryName);
        AbstractQueryImpl query = (AbstractQueryImpl)session.getNamedQuery(this.queryName);
        if (query.hasNamedParameters()) {
            query.setParameter(query.getNamedParameters()[0], (Object)id, this.persister.getIdentifierType());
        } else {
            query.setParameter(0, (Object)id, this.persister.getIdentifierType());
        }
        query.setOptionalId(id);
        query.setOptionalEntityName(this.persister.getEntityName());
        query.setOptionalObject(optionalObject);
        query.setFlushMode(FlushMode.MANUAL);
        query.list();
        return session.getPersistenceContext().getEntity(session.generateEntityKey(id, this.persister));
    }
}

