/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.ParameterMode;
import javax.persistence.TemporalType;
import org.evosuite.shaded.org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.procedure.ParameterBind;
import org.evosuite.shaded.org.hibernate.procedure.ParameterMisuseException;
import org.evosuite.shaded.org.hibernate.procedure.internal.ParameterBindImpl;
import org.evosuite.shaded.org.hibernate.procedure.internal.ProcedureCallImpl;
import org.evosuite.shaded.org.hibernate.procedure.spi.ParameterRegistrationImplementor;
import org.evosuite.shaded.org.hibernate.procedure.spi.ParameterStrategy;
import org.evosuite.shaded.org.hibernate.type.CalendarDateType;
import org.evosuite.shaded.org.hibernate.type.CalendarTimeType;
import org.evosuite.shaded.org.hibernate.type.CalendarType;
import org.evosuite.shaded.org.hibernate.type.ProcedureParameterExtractionAware;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public abstract class AbstractParameterRegistrationImpl<T>
implements ParameterRegistrationImplementor<T> {
    private static final Logger log = Logger.getLogger(AbstractParameterRegistrationImpl.class);
    private final ProcedureCallImpl procedureCall;
    private final Integer position;
    private final String name;
    private final ParameterMode mode;
    private final Class<T> type;
    private ParameterBindImpl bind;
    private int startIndex;
    private Type hibernateType;
    private int[] sqlTypes;

    protected AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, Integer position, ParameterMode mode, Class<T> type) {
        this(procedureCall, position, null, mode, type);
    }

    protected AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, Integer position, ParameterMode mode, Class<T> type, Type hibernateType) {
        this(procedureCall, position, null, mode, type, hibernateType);
    }

    protected AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, String name, ParameterMode mode, Class<T> type) {
        this(procedureCall, null, name, mode, type);
    }

    protected AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, String name, ParameterMode mode, Class<T> type, Type hibernateType) {
        this(procedureCall, null, name, mode, type, hibernateType);
    }

    private AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, Integer position, String name, ParameterMode mode, Class<T> type, Type hibernateType) {
        this.procedureCall = procedureCall;
        this.position = position;
        this.name = name;
        this.mode = mode;
        this.type = type;
        if (mode == ParameterMode.REF_CURSOR) {
            return;
        }
        this.setHibernateType(hibernateType);
    }

    private AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, Integer position, String name, ParameterMode mode, Class<T> type) {
        this(procedureCall, position, name, mode, type, procedureCall.getSession().getFactory().getTypeResolver().heuristicType(type.getName()));
    }

    protected SessionImplementor session() {
        return this.procedureCall.getSession();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public Type getHibernateType() {
        return this.hibernateType;
    }

    @Override
    public void setHibernateType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.hibernateType = type;
        this.sqlTypes = this.hibernateType.sqlTypes(this.session().getFactory());
    }

    @Override
    public ParameterBind<T> getBind() {
        return this.bind;
    }

    @Override
    public void bindValue(T value) {
        this.validateBindability();
        this.bind = new ParameterBindImpl<T>(value);
    }

    private void validateBindability() {
        if (!this.canBind()) {
            throw new ParameterMisuseException("Cannot bind value to non-input parameter : " + this);
        }
    }

    private boolean canBind() {
        return this.mode == ParameterMode.IN || this.mode == ParameterMode.INOUT;
    }

    @Override
    public void bindValue(T value, TemporalType explicitTemporalType) {
        this.validateBindability();
        if (explicitTemporalType != null && !this.isDateTimeType()) {
            throw new IllegalArgumentException("TemporalType should not be specified for non date/time type");
        }
        this.bind = new ParameterBindImpl<T>(value, explicitTemporalType);
    }

    private boolean isDateTimeType() {
        return Date.class.isAssignableFrom(this.type) || Calendar.class.isAssignableFrom(this.type);
    }

    @Override
    public void prepare(CallableStatement statement, int startIndex) throws SQLException {
        Type typeToUse = this.hibernateType;
        int[] sqlTypesToUse = this.sqlTypes;
        if (this.bind != null && this.bind.getExplicitTemporalType() != null && Calendar.class.isInstance(this.bind.getValue())) {
            switch (this.bind.getExplicitTemporalType()) {
                case TIMESTAMP: {
                    typeToUse = CalendarType.INSTANCE;
                    sqlTypesToUse = typeToUse.sqlTypes(this.session().getFactory());
                    break;
                }
                case DATE: {
                    typeToUse = CalendarDateType.INSTANCE;
                    sqlTypesToUse = typeToUse.sqlTypes(this.session().getFactory());
                    break;
                }
                case TIME: {
                    typeToUse = CalendarTimeType.INSTANCE;
                    sqlTypesToUse = typeToUse.sqlTypes(this.session().getFactory());
                }
            }
        }
        this.startIndex = startIndex;
        if (this.mode == ParameterMode.IN || this.mode == ParameterMode.INOUT || this.mode == ParameterMode.OUT) {
            if (this.mode == ParameterMode.INOUT || this.mode == ParameterMode.OUT) {
                if (sqlTypesToUse.length > 1) {
                    boolean canHandleMultiParamExtraction;
                    boolean bl = canHandleMultiParamExtraction = ProcedureParameterExtractionAware.class.isInstance(this.hibernateType) && ((ProcedureParameterExtractionAware)this.hibernateType).canDoExtraction();
                    if (!canHandleMultiParamExtraction) {
                        throw new UnsupportedOperationException("Type [" + this.hibernateType + "] does support multi-parameter value extraction");
                    }
                }
                for (int i = 0; i < sqlTypesToUse.length; ++i) {
                    statement.registerOutParameter(startIndex + i, sqlTypesToUse[i]);
                }
            }
            if (this.mode == ParameterMode.INOUT || this.mode == ParameterMode.IN) {
                if (this.bind == null || this.bind.getValue() == null) {
                    log.debugf("Stored procedure [%s] IN/INOUT parameter [%s] not bound; assuming procedure defines default value", (Object)this.procedureCall.getProcedureName(), (Object)this);
                } else {
                    typeToUse.nullSafeSet(statement, this.bind.getValue(), startIndex, this.session());
                }
            }
        } else if (this.procedureCall.getParameterStrategy() == ParameterStrategy.NAMED) {
            this.session().getFactory().getServiceRegistry().getService(RefCursorSupport.class).registerRefCursorParameter(statement, this.getName());
        } else {
            this.session().getFactory().getServiceRegistry().getService(RefCursorSupport.class).registerRefCursorParameter(statement, startIndex);
        }
    }

    @Override
    public int[] getSqlTypes() {
        if (this.mode == ParameterMode.REF_CURSOR) {
            throw new IllegalStateException("REF_CURSOR parameters do not have a SQL/JDBC type");
        }
        return this.sqlTypes;
    }

    @Override
    public T extract(CallableStatement statement) {
        if (this.mode == ParameterMode.IN) {
            throw new ParameterMisuseException("IN parameter not valid for output extraction");
        }
        if (this.mode == ParameterMode.REF_CURSOR) {
            throw new ParameterMisuseException("REF_CURSOR parameters should be accessed via results");
        }
        try {
            if (ProcedureParameterExtractionAware.class.isInstance(this.hibernateType)) {
                return ((ProcedureParameterExtractionAware)this.hibernateType).extract(statement, this.startIndex, this.session());
            }
            return (T)statement.getObject(this.startIndex);
        }
        catch (SQLException e) {
            throw this.procedureCall.getSession().getFactory().getSQLExceptionHelper().convert(e, "Unable to extract OUT/INOUT parameter value");
        }
    }
}

