/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.property;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.property.BackrefPropertyAccessor;
import org.evosuite.shaded.org.hibernate.property.Getter;
import org.evosuite.shaded.org.hibernate.property.PropertyAccessor;
import org.evosuite.shaded.org.hibernate.property.Setter;

public class IndexPropertyAccessor
implements PropertyAccessor {
    private final String propertyName;
    private final String entityName;

    public IndexPropertyAccessor(String collectionRole, String entityName) {
        this.propertyName = collectionRole.substring(entityName.length() + 1);
        this.entityName = entityName;
    }

    @Override
    public Setter getSetter(Class theClass, String propertyName) {
        return new IndexSetter();
    }

    @Override
    public Getter getGetter(Class theClass, String propertyName) {
        return new IndexGetter();
    }

    public class IndexGetter
    implements Getter {
        @Override
        public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) throws HibernateException {
            if (session == null) {
                return BackrefPropertyAccessor.UNKNOWN;
            }
            return session.getPersistenceContext().getIndexInOwner(IndexPropertyAccessor.this.entityName, IndexPropertyAccessor.this.propertyName, target, mergeMap);
        }

        @Override
        public Object get(Object target) {
            return BackrefPropertyAccessor.UNKNOWN;
        }

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return Object.class;
        }
    }

    public static final class IndexSetter
    implements Setter {
        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public void set(Object target, Object value, SessionFactoryImplementor factory) {
        }
    }
}

