/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.property;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.PropertyNotFoundException;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.property.Getter;
import org.evosuite.shaded.org.hibernate.property.PropertyAccessor;
import org.evosuite.shaded.org.hibernate.property.Setter;

public class MapAccessor
implements PropertyAccessor {
    @Override
    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new MapGetter(propertyName);
    }

    @Override
    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return new MapSetter(propertyName);
    }

    public static final class MapGetter
    implements Getter {
        private String name;

        MapGetter(String name) {
            this.name = name;
        }

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public Object get(Object target) throws HibernateException {
            return ((Map)target).get(this.name);
        }

        @Override
        public Object getForInsert(Object target, Map mergeMap, SessionImplementor session) {
            return this.get(target);
        }

        @Override
        public Class getReturnType() {
            return Object.class;
        }
    }

    public static final class MapSetter
    implements Setter {
        private String name;

        MapSetter(String name) {
            this.name = name;
        }

        @Override
        public Method getMethod() {
            return null;
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            ((Map)target).put(this.name, value);
        }
    }
}

