/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.evosuite.shaded.org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.internal.jaxb.Origin;
import org.evosuite.shaded.org.hibernate.internal.jaxb.SourceType;
import org.evosuite.shaded.org.hibernate.internal.jaxb.cfg.JaxbHibernateConfiguration;
import org.evosuite.shaded.org.hibernate.internal.util.ValueHolder;
import org.evosuite.shaded.org.hibernate.internal.util.config.ConfigurationException;
import org.evosuite.shaded.org.hibernate.service.internal.JaxbProcessor;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class ConfigLoader {
    private static final Logger log = Logger.getLogger(ConfigLoader.class);
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private ValueHolder<JaxbProcessor> jaxbProcessorHolder = new ValueHolder<1>(new ValueHolder.DeferredInitializer<JaxbProcessor>(){

        @Override
        public JaxbProcessor initialize() {
            return new JaxbProcessor(ConfigLoader.this.bootstrapServiceRegistry.getService(ClassLoaderService.class));
        }
    });

    public ConfigLoader(BootstrapServiceRegistry bootstrapServiceRegistry) {
        this.bootstrapServiceRegistry = bootstrapServiceRegistry;
    }

    public JaxbHibernateConfiguration loadConfigXmlResource(String cfgXmlResourceName) {
        InputStream stream = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResourceStream(cfgXmlResourceName);
        if (stream == null) {
            throw new ConfigurationException("Could not locate cfg.xml resource [" + cfgXmlResourceName + "]");
        }
        return this.jaxbProcessorHolder.getValue().unmarshal(stream, new Origin(SourceType.RESOURCE, cfgXmlResourceName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadProperties(String resourceName) {
        Properties properties2;
        InputStream stream = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResourceStream(resourceName);
        try {
            Properties properties = new Properties();
            properties.load(stream);
            properties2 = properties;
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException("Unable to apply settings from properties file [" + resourceName + "]", e);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    log.debug((Object)String.format("Unable to close properties file [%s] stream", resourceName), e2);
                }
                throw throwable;
            }
        }
        try {
            stream.close();
            return properties2;
        }
        catch (IOException e) {
            log.debug((Object)String.format("Unable to close properties file [%s] stream", resourceName), e);
        }
        return properties2;
    }
}

