/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.service.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConcurrentServiceBinding<K, V> {
    private static final Node EMPTY_LEAF = new Node<Object, Object>(new Entry<Object, Object>(0, null, null), null, null);
    private volatile Node<K, V> treeRoot = EMPTY_LEAF;

    public synchronized void clear() {
        this.treeRoot = EMPTY_LEAF;
    }

    public synchronized void put(K key, V value) {
        int code = this.hashKey(key);
        Entry<K, V> newEntry = new Entry<K, V>(code, key, value);
        ArrayList<Entry<K, V>> list = this.convertToArrayList(this.treeRoot, key);
        list.add(newEntry);
        Collections.sort(list);
        int size = list.size();
        Entry[] array = list.toArray(new Entry[size]);
        this.treeRoot = this.treeFromRange(array, 0, size);
    }

    private Node<K, V> treeFromRange(Entry<K, V>[] array, int minInclusive, int maxExclusive) {
        int mid;
        if (minInclusive == maxExclusive) {
            return null;
        }
        for (mid = (minInclusive + maxExclusive) / 2; mid > minInclusive && ((Entry)array[mid]).hash == ((Entry)array[mid - 1]).hash; --mid) {
        }
        return new Node<K, V>(array[mid], this.treeFromRange(array, minInclusive, mid), this.treeFromRange(array, mid + 1, maxExclusive));
    }

    public V get(K key) {
        int hash = this.hashKey(key);
        Node<K, V> root = this.treeRoot;
        return root.get(key, hash);
    }

    protected int hashKey(K key) {
        return System.identityHashCode(key);
    }

    public Iterable<V> values() {
        ArrayList list = new ArrayList();
        this.treeRoot.collectAllValuesInto(list);
        return list;
    }

    private final ArrayList<Entry<K, V>> convertToArrayList(Node<K, V> treeRoot, K exceptKey) {
        ArrayList<Entry<K, V>> list = new ArrayList<Entry<K, V>>();
        if (treeRoot != EMPTY_LEAF) {
            treeRoot.collectAllEntriesInto(list, exceptKey);
        }
        return list;
    }

    private static final class Node<K, V> {
        private final Entry<K, V> entry;
        private final Node<K, V> left;
        private final Node<K, V> right;

        Node(Entry<K, V> entry, Node<K, V> left, Node<K, V> right) {
            this.entry = entry;
            this.left = left;
            this.right = right;
        }

        public V get(K key, int hash) {
            if (((Entry)this.entry).key == key) {
                return (V)((Entry)this.entry).value;
            }
            if (hash < ((Entry)this.entry).hash) {
                return this.left == null ? null : (V)this.left.get(key, hash);
            }
            return this.right == null ? null : (V)this.right.get(key, hash);
        }

        public void collectAllEntriesInto(List<Entry<K, V>> list, K exceptKey) {
            if (this.entry != null && exceptKey != ((Entry)this.entry).key) {
                list.add(this.entry);
            }
            if (this.left != null) {
                this.left.collectAllEntriesInto(list, exceptKey);
            }
            if (this.right != null) {
                this.right.collectAllEntriesInto(list, exceptKey);
            }
        }

        public void collectAllValuesInto(List<V> list) {
            if (this.entry != null && ((Entry)this.entry).value != null) {
                list.add(((Entry)this.entry).value);
            }
            if (this.left != null) {
                this.left.collectAllValuesInto(list);
            }
            if (this.right != null) {
                this.right.collectAllValuesInto(list);
            }
        }

        private void renderToStringBuilder(StringBuilder sb, int indent) {
            sb.append(this.entry);
            this.appendIndented(sb, indent, "L-> ", this.left);
            this.appendIndented(sb, indent, "R-> ", this.right);
        }

        private void appendIndented(StringBuilder sb, int indent, String label, Node<K, V> node) {
            if (node == null) {
                return;
            }
            sb.append("\n");
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append(label);
            super.renderToStringBuilder(sb, indent + 1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.renderToStringBuilder(sb, 0);
            return sb.toString();
        }
    }

    private static final class Entry<K, V>
    implements Comparable<Entry<K, V>> {
        private final int hash;
        private final K key;
        private final V value;

        Entry(int keyHashCode, K key, V value) {
            this.hash = keyHashCode;
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Entry o) {
            return this.hash < o.hash ? -1 : (this.hash == o.hash ? 0 : 1);
        }

        public boolean equals(Object obj) {
            Entry other = (Entry)obj;
            return other.key == this.key;
        }

        public String toString() {
            return "<" + this.key + ", " + this.value + ">";
        }
    }
}

