/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.tuple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.evosuite.shaded.org.hibernate.InstantiationException;
import org.evosuite.shaded.org.hibernate.PropertyNotFoundException;
import org.evosuite.shaded.org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.ReflectHelper;
import org.evosuite.shaded.org.hibernate.mapping.Component;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.metamodel.binding.EntityBinding;
import org.evosuite.shaded.org.hibernate.tuple.Instantiator;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class PojoInstantiator
implements Instantiator,
Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PojoInstantiator.class.getName());
    private transient Constructor constructor;
    private final Class mappedClass;
    private final transient ReflectionOptimizer.InstantiationOptimizer optimizer;
    private final boolean embeddedIdentifier;
    private final Class proxyInterface;
    private final boolean isAbstract;

    public PojoInstantiator(Component component, ReflectionOptimizer.InstantiationOptimizer optimizer) {
        this.mappedClass = component.getComponentClass();
        this.isAbstract = ReflectHelper.isAbstractClass(this.mappedClass);
        this.optimizer = optimizer;
        this.proxyInterface = null;
        this.embeddedIdentifier = false;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    public PojoInstantiator(PersistentClass persistentClass, ReflectionOptimizer.InstantiationOptimizer optimizer) {
        this.mappedClass = persistentClass.getMappedClass();
        this.isAbstract = ReflectHelper.isAbstractClass(this.mappedClass);
        this.proxyInterface = persistentClass.getProxyInterface();
        this.embeddedIdentifier = persistentClass.hasEmbeddedIdentifier();
        this.optimizer = optimizer;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    public PojoInstantiator(EntityBinding entityBinding, ReflectionOptimizer.InstantiationOptimizer optimizer) {
        this.mappedClass = entityBinding.getEntity().getClassReference();
        this.isAbstract = ReflectHelper.isAbstractClass(this.mappedClass);
        this.proxyInterface = entityBinding.getProxyInterfaceType().getValue();
        this.embeddedIdentifier = entityBinding.getHierarchyDetails().getEntityIdentifier().isEmbedded();
        this.optimizer = optimizer;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
    }

    @Override
    public Object instantiate() {
        if (this.isAbstract) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.mappedClass);
        }
        if (this.optimizer != null) {
            return this.optimizer.newInstance();
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
        }
    }

    @Override
    public Object instantiate(Serializable id) {
        boolean useEmbeddedIdentifierInstanceAsEntity = this.embeddedIdentifier && id != null && id.getClass().equals(this.mappedClass);
        return useEmbeddedIdentifierInstanceAsEntity ? id : this.instantiate();
    }

    @Override
    public boolean isInstance(Object object) {
        return this.mappedClass.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

