/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.type.AdaptedImmutableType;
import org.evosuite.shaded.org.hibernate.type.BasicType;
import org.evosuite.shaded.org.hibernate.type.BigDecimalType;
import org.evosuite.shaded.org.hibernate.type.BigIntegerType;
import org.evosuite.shaded.org.hibernate.type.BinaryType;
import org.evosuite.shaded.org.hibernate.type.BlobType;
import org.evosuite.shaded.org.hibernate.type.BooleanType;
import org.evosuite.shaded.org.hibernate.type.ByteType;
import org.evosuite.shaded.org.hibernate.type.CalendarDateType;
import org.evosuite.shaded.org.hibernate.type.CalendarType;
import org.evosuite.shaded.org.hibernate.type.CharArrayType;
import org.evosuite.shaded.org.hibernate.type.CharacterArrayType;
import org.evosuite.shaded.org.hibernate.type.CharacterNCharType;
import org.evosuite.shaded.org.hibernate.type.CharacterType;
import org.evosuite.shaded.org.hibernate.type.ClassType;
import org.evosuite.shaded.org.hibernate.type.ClobType;
import org.evosuite.shaded.org.hibernate.type.CompositeCustomType;
import org.evosuite.shaded.org.hibernate.type.CurrencyType;
import org.evosuite.shaded.org.hibernate.type.CustomType;
import org.evosuite.shaded.org.hibernate.type.DateType;
import org.evosuite.shaded.org.hibernate.type.DbTimestampType;
import org.evosuite.shaded.org.hibernate.type.DoubleType;
import org.evosuite.shaded.org.hibernate.type.FloatType;
import org.evosuite.shaded.org.hibernate.type.ImageType;
import org.evosuite.shaded.org.hibernate.type.IntegerType;
import org.evosuite.shaded.org.hibernate.type.LocaleType;
import org.evosuite.shaded.org.hibernate.type.LongType;
import org.evosuite.shaded.org.hibernate.type.MaterializedBlobType;
import org.evosuite.shaded.org.hibernate.type.MaterializedClobType;
import org.evosuite.shaded.org.hibernate.type.MaterializedNClobType;
import org.evosuite.shaded.org.hibernate.type.NClobType;
import org.evosuite.shaded.org.hibernate.type.NTextType;
import org.evosuite.shaded.org.hibernate.type.NumericBooleanType;
import org.evosuite.shaded.org.hibernate.type.ObjectType;
import org.evosuite.shaded.org.hibernate.type.PostgresUUIDType;
import org.evosuite.shaded.org.hibernate.type.SerializableType;
import org.evosuite.shaded.org.hibernate.type.ShortType;
import org.evosuite.shaded.org.hibernate.type.StringNVarcharType;
import org.evosuite.shaded.org.hibernate.type.StringType;
import org.evosuite.shaded.org.hibernate.type.TextType;
import org.evosuite.shaded.org.hibernate.type.TimeType;
import org.evosuite.shaded.org.hibernate.type.TimeZoneType;
import org.evosuite.shaded.org.hibernate.type.TimestampType;
import org.evosuite.shaded.org.hibernate.type.TrueFalseType;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.hibernate.type.UUIDBinaryType;
import org.evosuite.shaded.org.hibernate.type.UUIDCharType;
import org.evosuite.shaded.org.hibernate.type.UrlType;
import org.evosuite.shaded.org.hibernate.type.WrapperBinaryType;
import org.evosuite.shaded.org.hibernate.type.YesNoType;
import org.evosuite.shaded.org.hibernate.usertype.CompositeUserType;
import org.evosuite.shaded.org.hibernate.usertype.UserType;

public class BasicTypeRegistry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BasicTypeRegistry.class);
    private Map<String, BasicType> registry = new ConcurrentHashMap<String, BasicType>(100, 0.75f, 1);
    private boolean locked;

    public BasicTypeRegistry() {
        this.register(BooleanType.INSTANCE);
        this.register(NumericBooleanType.INSTANCE);
        this.register(TrueFalseType.INSTANCE);
        this.register(YesNoType.INSTANCE);
        this.register(ByteType.INSTANCE);
        this.register(CharacterType.INSTANCE);
        this.register(ShortType.INSTANCE);
        this.register(IntegerType.INSTANCE);
        this.register(LongType.INSTANCE);
        this.register(FloatType.INSTANCE);
        this.register(DoubleType.INSTANCE);
        this.register(BigDecimalType.INSTANCE);
        this.register(BigIntegerType.INSTANCE);
        this.register(StringType.INSTANCE);
        this.register(StringNVarcharType.INSTANCE);
        this.register(CharacterNCharType.INSTANCE);
        this.register(UrlType.INSTANCE);
        this.register(DateType.INSTANCE);
        this.register(TimeType.INSTANCE);
        this.register(TimestampType.INSTANCE);
        this.register(DbTimestampType.INSTANCE);
        this.register(CalendarType.INSTANCE);
        this.register(CalendarDateType.INSTANCE);
        this.register(LocaleType.INSTANCE);
        this.register(CurrencyType.INSTANCE);
        this.register(TimeZoneType.INSTANCE);
        this.register(ClassType.INSTANCE);
        this.register(UUIDBinaryType.INSTANCE);
        this.register(UUIDCharType.INSTANCE);
        this.register(PostgresUUIDType.INSTANCE);
        this.register(BinaryType.INSTANCE);
        this.register(WrapperBinaryType.INSTANCE);
        this.register(ImageType.INSTANCE);
        this.register(CharArrayType.INSTANCE);
        this.register(CharacterArrayType.INSTANCE);
        this.register(TextType.INSTANCE);
        this.register(NTextType.INSTANCE);
        this.register(BlobType.INSTANCE);
        this.register(MaterializedBlobType.INSTANCE);
        this.register(ClobType.INSTANCE);
        this.register(NClobType.INSTANCE);
        this.register(MaterializedClobType.INSTANCE);
        this.register(MaterializedNClobType.INSTANCE);
        this.register(SerializableType.INSTANCE);
        this.register(ObjectType.INSTANCE);
        this.register(new AdaptedImmutableType<Date>(DateType.INSTANCE));
        this.register(new AdaptedImmutableType<Date>(TimeType.INSTANCE));
        this.register(new AdaptedImmutableType<Date>(TimestampType.INSTANCE));
        this.register(new AdaptedImmutableType<Date>(DbTimestampType.INSTANCE));
        this.register(new AdaptedImmutableType<Calendar>(CalendarType.INSTANCE));
        this.register(new AdaptedImmutableType<Calendar>(CalendarDateType.INSTANCE));
        this.register(new AdaptedImmutableType<byte[]>(BinaryType.INSTANCE));
        this.register(new AdaptedImmutableType<Serializable>(SerializableType.INSTANCE));
    }

    private BasicTypeRegistry(Map<String, BasicType> registeredTypes) {
        this.registry.putAll(registeredTypes);
        this.locked = true;
    }

    public void register(BasicType type) {
        if (this.locked) {
            throw new HibernateException("Can not alter TypeRegistry at this time");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        if (type.getRegistrationKeys() == null || type.getRegistrationKeys().length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
        }
        for (String key : type.getRegistrationKeys()) {
            if (key == null) continue;
            LOG.debugf("Adding type registration %s -> %s", (Object)key, (Object)type);
            Type old = this.registry.put(key, type);
            if (old == null || old == type) continue;
            LOG.typeRegistrationOverridesPrevious(key, old);
        }
    }

    public void register(UserType type, String[] keys) {
        this.register(new CustomType(type, keys));
    }

    public void register(CompositeUserType type, String[] keys) {
        this.register(new CompositeCustomType(type, keys));
    }

    public BasicType getRegisteredType(String key) {
        return this.registry.get(key);
    }

    public BasicTypeRegistry shallowCopy() {
        return new BasicTypeRegistry(this.registry);
    }
}

