/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.evosuite.shaded.org.hibernate.type.DiscriminatorType;
import org.evosuite.shaded.org.hibernate.type.PrimitiveType;
import org.evosuite.shaded.org.hibernate.type.VersionType;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ShortTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.SmallIntTypeDescriptor;

public class ShortType
extends AbstractSingleColumnStandardBasicType<Short>
implements PrimitiveType<Short>,
DiscriminatorType<Short>,
VersionType<Short> {
    public static final ShortType INSTANCE = new ShortType();
    private static final Short ZERO = 0;

    public ShortType() {
        super(SmallIntTypeDescriptor.INSTANCE, ShortTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "short";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Short.TYPE.getName(), Short.class.getName()};
    }

    @Override
    public Serializable getDefaultValue() {
        return ZERO;
    }

    @Override
    public Class getPrimitiveClass() {
        return Short.TYPE;
    }

    @Override
    public String objectToSQLString(Short value, Dialect dialect) throws Exception {
        return value.toString();
    }

    @Override
    public Short stringToObject(String xml) throws Exception {
        return Short.valueOf(xml);
    }

    @Override
    public Short next(Short current, SessionImplementor session) {
        return (short)(current + 1);
    }

    @Override
    public Short seed(SessionImplementor session) {
        return ZERO;
    }

    @Override
    public Comparator<Short> getComparator() {
        return this.getJavaTypeDescriptor().getComparator();
    }
}

