/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.util.Comparator;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.internal.util.compare.ComparableComparator;
import org.evosuite.shaded.org.hibernate.internal.util.compare.EqualsHelper;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JavaTypeDescriptorRegistry;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.MutabilityPlan;

public abstract class AbstractTypeDescriptor<T>
implements JavaTypeDescriptor<T>,
Serializable {
    private final Class<T> type;
    private final MutabilityPlan<T> mutabilityPlan;
    private final Comparator<T> comparator;

    protected AbstractTypeDescriptor(Class<T> type) {
        this(type, ImmutableMutabilityPlan.INSTANCE);
    }

    protected AbstractTypeDescriptor(Class<T> type, MutabilityPlan<T> mutabilityPlan) {
        this.type = type;
        this.mutabilityPlan = mutabilityPlan;
        this.comparator = Comparable.class.isAssignableFrom(type) ? ComparableComparator.INSTANCE : null;
        JavaTypeDescriptorRegistry.INSTANCE.addDescriptor(this);
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public Class<T> getJavaTypeClass() {
        return this.type;
    }

    @Override
    public int extractHashCode(T value) {
        return value.hashCode();
    }

    @Override
    public boolean areEqual(T one, T another) {
        return EqualsHelper.equals(one, another);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public String extractLoggableRepresentation(T value) {
        return value == null ? "null" : value.toString();
    }

    protected HibernateException unknownUnwrap(Class conversionType) {
        throw new HibernateException("Unknown unwrap conversion requested: " + this.type.getName() + " to " + conversionType.getName());
    }

    protected HibernateException unknownWrap(Class conversionType) {
        throw new HibernateException("Unknown wrap conversion requested: " + conversionType.getName() + " to " + this.type.getName());
    }
}

