/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type.descriptor.sql;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.evosuite.shaded.org.hibernate.type.descriptor.ValueBinder;
import org.evosuite.shaded.org.hibernate.type.descriptor.ValueExtractor;
import org.evosuite.shaded.org.hibernate.type.descriptor.WrapperOptions;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BasicBinder;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BasicExtractor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class RealTypeDescriptor
implements SqlTypeDescriptor {
    public static final RealTypeDescriptor INSTANCE = new RealTypeDescriptor();

    @Override
    public int getSqlType() {
        return 7;
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setFloat(index, javaTypeDescriptor.unwrap(value, Float.class, options).floatValue());
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(Float.valueOf(rs.getFloat(name)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(Float.valueOf(statement.getFloat(index)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap(Float.valueOf(statement.getFloat(name)), options);
            }
        };
    }
}

