/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.type.descriptor.sql;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.hibernate.type.descriptor.JdbcTypeNameMapper;
import org.evosuite.shaded.org.hibernate.type.descriptor.ValueBinder;
import org.evosuite.shaded.org.hibernate.type.descriptor.ValueExtractor;
import org.evosuite.shaded.org.hibernate.type.descriptor.WrapperOptions;
import org.evosuite.shaded.org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BasicBinder;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BasicExtractor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BigIntTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BinaryTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BitTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BlobTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.BooleanTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.CharTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.DateTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.DecimalTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.DoubleTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.FloatTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.IntegerTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.JdbcTypeFamilyInformation;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.LongNVarcharTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.LongVarbinaryTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.LongVarcharTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.NCharTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.NClobTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.NVarcharTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.NumericTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.RealTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.SmallIntTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.TimeTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.TinyIntTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.VarbinaryTypeDescriptor;
import org.evosuite.shaded.org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class SqlTypeDescriptorRegistry {
    public static final SqlTypeDescriptorRegistry INSTANCE = new SqlTypeDescriptorRegistry();
    private static final Logger log = Logger.getLogger(SqlTypeDescriptorRegistry.class);
    private ConcurrentHashMap<Integer, SqlTypeDescriptor> descriptorMap = new ConcurrentHashMap();

    private SqlTypeDescriptorRegistry() {
        this.addDescriptor(BooleanTypeDescriptor.INSTANCE);
        this.addDescriptor(BitTypeDescriptor.INSTANCE);
        this.addDescriptor(BigIntTypeDescriptor.INSTANCE);
        this.addDescriptor(DecimalTypeDescriptor.INSTANCE);
        this.addDescriptor(DoubleTypeDescriptor.INSTANCE);
        this.addDescriptor(FloatTypeDescriptor.INSTANCE);
        this.addDescriptor(IntegerTypeDescriptor.INSTANCE);
        this.addDescriptor(NumericTypeDescriptor.INSTANCE);
        this.addDescriptor(RealTypeDescriptor.INSTANCE);
        this.addDescriptor(SmallIntTypeDescriptor.INSTANCE);
        this.addDescriptor(TinyIntTypeDescriptor.INSTANCE);
        this.addDescriptor(DateTypeDescriptor.INSTANCE);
        this.addDescriptor(TimestampTypeDescriptor.INSTANCE);
        this.addDescriptor(TimeTypeDescriptor.INSTANCE);
        this.addDescriptor(BinaryTypeDescriptor.INSTANCE);
        this.addDescriptor(VarbinaryTypeDescriptor.INSTANCE);
        this.addDescriptor(LongVarbinaryTypeDescriptor.INSTANCE);
        this.addDescriptor(BlobTypeDescriptor.DEFAULT);
        this.addDescriptor(CharTypeDescriptor.INSTANCE);
        this.addDescriptor(VarcharTypeDescriptor.INSTANCE);
        this.addDescriptor(LongVarcharTypeDescriptor.INSTANCE);
        this.addDescriptor(ClobTypeDescriptor.DEFAULT);
        this.addDescriptor(NCharTypeDescriptor.INSTANCE);
        this.addDescriptor(NVarcharTypeDescriptor.INSTANCE);
        this.addDescriptor(LongNVarcharTypeDescriptor.INSTANCE);
        this.addDescriptor(NClobTypeDescriptor.DEFAULT);
    }

    public void addDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        this.descriptorMap.put(sqlTypeDescriptor.getSqlType(), sqlTypeDescriptor);
    }

    public SqlTypeDescriptor getDescriptor(int jdbcTypeCode) {
        JdbcTypeFamilyInformation.Family family;
        SqlTypeDescriptor descriptor = this.descriptorMap.get(jdbcTypeCode);
        if (descriptor != null) {
            return descriptor;
        }
        if (JdbcTypeNameMapper.isStandardTypeCode(jdbcTypeCode)) {
            log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", (Object)jdbcTypeCode);
        }
        if ((family = JdbcTypeFamilyInformation.INSTANCE.locateJdbcTypeFamilyByTypeCode(jdbcTypeCode)) != null) {
            for (int potentialAlternateTypeCode : family.getTypeCodes()) {
                if (potentialAlternateTypeCode == jdbcTypeCode) continue;
                SqlTypeDescriptor potentialAlternateDescriptor = this.descriptorMap.get(potentialAlternateTypeCode);
                if (potentialAlternateDescriptor != null) {
                    return potentialAlternateDescriptor;
                }
                if (!JdbcTypeNameMapper.isStandardTypeCode(potentialAlternateTypeCode)) continue;
                log.debugf("A standard JDBC type code [%s] was not defined in SqlTypeDescriptorRegistry", (Object)potentialAlternateTypeCode);
            }
        }
        ObjectSqlTypeDescriptor fallBackDescriptor = new ObjectSqlTypeDescriptor(jdbcTypeCode);
        this.addDescriptor(fallBackDescriptor);
        return fallBackDescriptor;
    }

    public static class ObjectSqlTypeDescriptor
    implements SqlTypeDescriptor {
        private final int jdbcTypeCode;

        public ObjectSqlTypeDescriptor(int jdbcTypeCode) {
            this.jdbcTypeCode = jdbcTypeCode;
        }

        @Override
        public int getSqlType() {
            return this.jdbcTypeCode;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        @Override
        public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
            if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
                return VarbinaryTypeDescriptor.INSTANCE.getBinder(javaTypeDescriptor);
            }
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    st.setObject(index, value, ObjectSqlTypeDescriptor.this.jdbcTypeCode);
                }
            };
        }

        public ValueExtractor getExtractor(JavaTypeDescriptor javaTypeDescriptor) {
            if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
                return VarbinaryTypeDescriptor.INSTANCE.getExtractor(javaTypeDescriptor);
            }
            return new BasicExtractor(javaTypeDescriptor, this){

                protected Object doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                    return rs.getObject(name);
                }

                protected Object doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                    return statement.getObject(index);
                }

                protected Object doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                    return statement.getObject(name);
                }
            };
        }
    }
}

