/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evosuite.shaded.org.hsqldb.Expression;
import org.evosuite.shaded.org.hsqldb.ExpressionArithmetic;
import org.evosuite.shaded.org.hsqldb.ExpressionLogical;
import org.evosuite.shaded.org.hsqldb.ExpressionOp;
import org.evosuite.shaded.org.hsqldb.ExpressionValue;
import org.evosuite.shaded.org.hsqldb.FunctionSQL;
import org.evosuite.shaded.org.hsqldb.HsqlDateTime;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.SortAndSlice;
import org.evosuite.shaded.org.hsqldb.Tokens;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;
import org.evosuite.shaded.org.hsqldb.lib.IntKeyIntValueHashMap;
import org.evosuite.shaded.org.hsqldb.lib.StringConverter;
import org.evosuite.shaded.org.hsqldb.lib.StringUtil;
import org.evosuite.shaded.org.hsqldb.map.BitMap;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.persist.Crypto;
import org.evosuite.shaded.org.hsqldb.types.ArrayType;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.BinaryType;
import org.evosuite.shaded.org.hsqldb.types.BlobData;
import org.evosuite.shaded.org.hsqldb.types.CharacterType;
import org.evosuite.shaded.org.hsqldb.types.ClobData;
import org.evosuite.shaded.org.hsqldb.types.DateTimeType;
import org.evosuite.shaded.org.hsqldb.types.IntervalMonthData;
import org.evosuite.shaded.org.hsqldb.types.IntervalSecondData;
import org.evosuite.shaded.org.hsqldb.types.IntervalType;
import org.evosuite.shaded.org.hsqldb.types.LobData;
import org.evosuite.shaded.org.hsqldb.types.NumberType;
import org.evosuite.shaded.org.hsqldb.types.TimeData;
import org.evosuite.shaded.org.hsqldb.types.TimestampData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASIN = 75;
    private static final int FUNC_ATAN = 76;
    private static final int FUNC_ATAN2 = 77;
    private static final int FUNC_BITAND = 78;
    private static final int FUNC_BITANDNOT = 79;
    private static final int FUNC_BITNOT = 80;
    private static final int FUNC_BITOR = 81;
    private static final int FUNC_BITXOR = 82;
    private static final int FUNC_CHAR = 83;
    private static final int FUNC_CONCAT = 84;
    private static final int FUNC_COS = 85;
    private static final int FUNC_COT = 86;
    private static final int FUNC_CRYPT_KEY = 87;
    private static final int FUNC_DATABASE = 88;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 89;
    private static final int FUNC_DATABASE_NAME = 90;
    private static final int FUNC_DATABASE_TIMEZONE = 91;
    private static final int FUNC_DATABASE_VERSION = 92;
    private static final int FUNC_DATE_ADD = 93;
    private static final int FUNC_DATE_SUB = 94;
    private static final int FUNC_DATEADD = 95;
    private static final int FUNC_DATEDIFF = 96;
    private static final int FUNC_DAYS = 97;
    private static final int FUNC_DBTIMEZONE = 98;
    private static final int FUNC_DEGREES = 99;
    private static final int FUNC_DIAGNOSTICS = 100;
    private static final int FUNC_DIFFERENCE = 101;
    private static final int FUNC_FROM_TZ = 102;
    private static final int FUNC_HEXTORAW = 103;
    private static final int FUNC_IDENTITY = 104;
    private static final int FUNC_INSTR = 105;
    private static final int FUNC_ISAUTOCOMMIT = 106;
    private static final int FUNC_ISOLATION_LEVEL = 107;
    private static final int FUNC_ISREADONLYDATABASE = 108;
    private static final int FUNC_ISREADONLYDATABASEFILES = 109;
    private static final int FUNC_ISREADONLYSESSION = 110;
    private static final int FUNC_LAST_DAY = 111;
    private static final int FUNC_LEFT = 112;
    private static final int FUNC_LOAD_FILE = 113;
    private static final int FUNC_LOB_ID = 114;
    private static final int FUNC_LOCATE = 115;
    private static final int FUNC_LOG10 = 116;
    private static final int FUNC_LPAD = 117;
    private static final int FUNC_LTRIM = 118;
    private static final int FUNC_MONTHS_BETWEEN = 119;
    private static final int FUNC_NEW_TIME = 120;
    private static final int FUNC_NEXT_DAY = 121;
    private static final int FUNC_NUMTODSINTERVAL = 122;
    private static final int FUNC_NUMTOYMINTERVAL = 123;
    private static final int FUNC_PI = 124;
    private static final int FUNC_POSITION_ARRAY = 125;
    private static final int FUNC_RADIANS = 126;
    private static final int FUNC_RAND = 127;
    private static final int FUNC_RAWTOHEX = 128;
    private static final int FUNC_REGEXP_MATCHES = 129;
    private static final int FUNC_REGEXP_SUBSTRING = 130;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 131;
    private static final int FUNC_REPEAT = 132;
    private static final int FUNC_REPLACE = 133;
    private static final int FUNC_REVERSE = 134;
    private static final int FUNC_RIGHT = 135;
    private static final int FUNC_ROUND = 136;
    private static final int FUNC_ROUNDMAGIC = 137;
    private static final int FUNC_RPAD = 138;
    private static final int FUNC_RTRIM = 139;
    private static final int FUNC_SECONDS_MIDNIGHT = 140;
    private static final int FUNC_SEQUENCE_ARRAY = 141;
    private static final int FUNC_SESSION_ID = 142;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 143;
    private static final int FUNC_SESSION_TIMEZONE = 144;
    private static final int FUNC_SESSIONTIMEZONE = 145;
    private static final int FUNC_SIGN = 146;
    private static final int FUNC_SIN = 147;
    private static final int FUNC_SOUNDEX = 148;
    private static final int FUNC_SORT_ARRAY = 149;
    private static final int FUNC_SPACE = 150;
    private static final int FUNC_SUBSTR = 151;
    private static final int FUNC_SYS_EXTRACT_UTC = 152;
    private static final int FUNC_SYSDATE = 153;
    private static final int FUNC_SYSTIMESTAMP = 154;
    private static final int FUNC_TAN = 155;
    private static final int FUNC_TIMESTAMP = 156;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 157;
    private static final int FUNC_TIMESTAMPADD = 158;
    private static final int FUNC_TIMESTAMPDIFF = 159;
    private static final int FUNC_TIMEZONE = 160;
    private static final int FUNC_TO_CHAR = 161;
    private static final int FUNC_TO_DATE = 162;
    private static final int FUNC_TO_DSINTERVAL = 163;
    private static final int FUNC_TO_YMINTERVAL = 164;
    private static final int FUNC_TO_NUMBER = 165;
    private static final int FUNC_TO_TIMESTAMP = 166;
    private static final int FUNC_TO_TIMESTAMP_TZ = 167;
    private static final int FUNC_TRANSACTION_CONTROL = 168;
    private static final int FUNC_TRANSACTION_ID = 169;
    private static final int FUNC_TRANSACTION_SIZE = 170;
    private static final int FUNC_TRANSLATE = 171;
    private static final int FUNC_TRUNC = 172;
    private static final int FUNC_TRUNCATE = 173;
    private static final int FUNC_UUID = 174;
    private static final int FUNC_UNIX_TIMESTAMP = 175;
    private static final int FUNC_UNIX_MILLIS = 176;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private IntKeyIntValueHashMap charLookup;

    public static FunctionSQL newCustomFunction(String string, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 431: 
            case 651: 
            case 698: 
            case 703: 
            case 719: 
            case 779: {
                return new FunctionSQL(n2);
            }
            case 661: 
            case 662: 
            case 716: 
            case 772: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 756: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                return functionSQL;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 31) {
            switch (n) {
                case 706: {
                    functionCustom.extractSpec = 151;
                    break;
                }
                case 733: {
                    functionCustom.extractSpec = 286;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 675: {
                    functionCustom.extractSpec = 671;
                    break;
                }
                case 709: {
                    functionCustom.extractSpec = 708;
                    break;
                }
                case 676: {
                    functionCustom.extractSpec = 672;
                    break;
                }
                case 677: {
                    functionCustom.extractSpec = 673;
                    break;
                }
                case 678: {
                    functionCustom.extractSpec = 674;
                    break;
                }
                case 790: {
                    functionCustom.extractSpec = 791;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 153: 
            case 154: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 98: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 124: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 160: 
            case 168: 
            case 169: 
            case 170: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 80: 
            case 83: 
            case 85: 
            case 86: 
            case 97: 
            case 99: 
            case 103: 
            case 111: 
            case 114: 
            case 116: 
            case 126: 
            case 128: 
            case 134: 
            case 137: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 152: 
            case 155: 
            case 157: 
            case 163: 
            case 164: 
            case 165: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 87: 
            case 101: 
            case 102: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 135: 
            case 161: {
                this.parseList = doubleParamList;
                break;
            }
            case 113: 
            case 136: 
            case 156: 
            case 162: 
            case 166: 
            case 167: 
            case 172: 
            case 173: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 96: {
                this.parseList = new short[]{816, 818, 804, 818, 864, 2, 804, 818, 802};
                break;
            }
            case 93: 
            case 94: {
                this.parseList = doubleParamList;
                break;
            }
            case 95: 
            case 120: 
            case 141: 
            case 171: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 117: 
            case 133: 
            case 138: {
                this.parseList = new short[]{816, 818, 804, 818, 864, 2, 804, 818, 802};
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 104: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 100: {
                this.parseList = new short[]{816, 495, 802};
                break;
            }
            case 125: {
                this.parseList = new short[]{816, 818, 130, 818, 864, 2, 115, 818, 802};
                break;
            }
            case 149: {
                this.parseList = new short[]{816, 818, 864, 4, 863, 2, 338, 389, 864, 5, 451, 863, 2, 401, 430, 802};
                break;
            }
            case 158: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{816, 863, 10, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 804, 818, 804, 818, 802};
                break;
            }
            case 159: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{816, 863, 10, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 804, 818, 804, 818, 802};
                break;
            }
            case 127: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 1: {
                Expression[] expressionArray2 = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    expressionArray2[0] = expressionArray[0];
                    expressionArray2[1] = expressionArray[1];
                    expressionArray2[3] = expressionArray[2];
                    expressionArray = expressionArray2;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                expressionArray2[0] = expressionArray[1];
                expressionArray2[1] = expressionArray[0];
                expressionArray2[3] = expressionArray[2];
                expressionArray = expressionArray2;
                break;
            }
            case 32: {
                Expression expression = expressionArray[1];
                Expression expression2 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression;
                expressionArray[3] = expression2;
                break;
            }
            case 5: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray3;
                break;
            }
            case 31: {
                Expression[] expressionArray4 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), expressionArray[0]};
                expressionArray = expressionArray4;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 84: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, objectArray);
            }
            case 88: {
                return session.getDatabase().getPath();
            }
            case 90: {
                return session.getDatabase().getUniqueName();
            }
            case 106: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 110: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 108: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 109: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 107: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 143: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 89: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 168: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 160: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 144: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 91: {
                int n = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(n, 0);
            }
            case 92: {
                return "2.3.2";
            }
            case 142: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 169: {
                return session.transactionTimestamp;
            }
            case 170: {
                return (long)session.actionIndex;
            }
            case 114: {
                LobData lobData = (LobData)objectArray[0];
                if (lobData == null) {
                    return null;
                }
                return lobData.getId();
            }
            case 104: {
                Number number = session.getLastIdentity();
                if (number instanceof Long) {
                    return number;
                }
                return ValuePool.getLong(number.longValue());
            }
            case 100: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 141: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                Object object = objectArray[0];
                Type type = this.nodes[0].getDataType();
                boolean bl = type.compare(session, objectArray[1], objectArray[0]) >= 0;
                while (true) {
                    int n = type.compare(session, object, objectArray[1]);
                    if (bl ? n > 0 : n < 0) break;
                    hsqlArrayList.add(object);
                    Object object2 = type.add(session, object, objectArray[2], this.nodes[2].getDataType());
                    n = type.compare(session, object, object2);
                    if (bl ? n >= 0 : n <= 0) break;
                    object = object2;
                }
                Object[] objectArray2 = hsqlArrayList.toArray();
                return objectArray2;
            }
            case 158: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 852: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 853: {
                        long l3 = l / 1000L;
                        int n3 = (int)(l % 1000L) * 1000000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l3, n3, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 854: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 855: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 856: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 857: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 858: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 859: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 860: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 861: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 159: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    timestampData = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    timestampData2 = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData2, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (n) {
                    case 852: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return new Long(1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos());
                    }
                    case 853: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return new Long(1000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000000));
                    }
                    case 854: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 855: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 856: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 857: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 858: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)) / 7L);
                    }
                    case 859: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                    case 860: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)) / 3L);
                    }
                    case 861: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 93: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.add(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 94: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 97: {
                if (objectArray[0] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, objectArray[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(intervalSecondData.getSeconds() / 86400L + 1L));
            }
            case 136: 
            case 172: {
                int n = 103;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType dateTimeType = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (objectArray[1] == null) {
                            return null;
                        }
                        n = HsqlDateTime.toStandardIntervalPart((String)objectArray[1]);
                    }
                    if (n < 0) {
                        throw Error.error(5566, (String)objectArray[1]);
                    }
                    return this.funcType == 136 ? dateTimeType.round(objectArray[0], n) : dateTimeType.truncate(objectArray[0], n);
                }
            }
            case 173: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    n = ((Number)objectArray[1]).intValue();
                }
                return this.funcType == 136 ? ((NumberType)this.dataType).round(objectArray[0], n) : ((NumberType)this.dataType).truncate(objectArray[0], n);
            }
            case 161: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, objectArray[0]);
                return HsqlDateTime.toFormattedDate(date, (String)objectArray[1], simpleDateFormat);
            }
            case 165: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 162: 
            case 166: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                TimestampData timestampData = HsqlDateTime.toDate((String)objectArray[0], (String)objectArray[1], simpleDateFormat);
                if (this.funcType == 162) {
                    timestampData.clearNanos();
                }
                return timestampData;
            }
            case 156: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        return new TimestampData(((Number)objectArray[0]).longValue());
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException hsqlException) {
                        return Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 157: {
                int n;
                long l;
                Calendar calendar = session.getCalendar();
                int n4 = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    l = ((Number)objectArray[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                    l = HsqlDateTime.convertMillisToCalendar(calendar, l * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)objectArray[1]);
                }
                Calendar calendar2 = calendar;
                synchronized (calendar2) {
                    calendar.setTimeInMillis(l * 1000L);
                    n = HsqlDateTime.getZoneSeconds(calendar);
                }
                return new TimestampData(l, n4, n);
            }
            case 124: {
                return new Double(Math.PI);
            }
            case 127: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return new Double(session.random(l));
            }
            case 174: {
                if (this.nodes[0] == null) {
                    UUID uUID = UUID.randomUUID();
                    long l = uUID.getMostSignificantBits();
                    long l4 = uUID.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(l, l4), false);
                }
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isBinaryType()) {
                    return new BinaryData(StringConverter.toBinaryUUID((String)objectArray[0]), false);
                }
                return StringConverter.toStringUUID(((BinaryData)objectArray[0]).getBytes());
            }
            case 176: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp(true);
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                long l = timestampData.getSeconds() * 1000L + (long)(timestampData.getNanos() / 1000000);
                return l;
            }
            case 175: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp(true);
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                return timestampData.getSeconds();
            }
            case 71: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.acos(d));
            }
            case 75: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.asin(d));
            }
            case 76: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.atan(d));
            }
            case 85: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.cos(d));
            }
            case 86: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return new Double(d2);
            }
            case 99: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toDegrees(d));
            }
            case 147: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.sin(d));
            }
            case 155: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.tan(d));
            }
            case 116: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.log10(d));
            }
            case 126: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toRadians(d));
            }
            case 146: {
                if (objectArray[0] == null) {
                    return null;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return ValuePool.getInt(n);
            }
            case 77: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return new Double(Math.atan2(d, d3));
            }
            case 74: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(string.charAt(0));
            }
            case 83: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 137: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    n = ((Number)objectArray[1]).intValue();
                }
                return ((NumberType)this.dataType).round(objectArray[0], n);
            }
            case 148: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string), 0, 4);
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long l = 0L;
                    long l5 = 0L;
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    long l6 = ((Number)objectArray[0]).longValue();
                    if (this.funcType != 80) {
                        objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                        l5 = ((Number)objectArray[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 78: {
                            l = l6 & l5;
                            break;
                        }
                        case 79: {
                            l = l6 & (l5 ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 80: {
                            l = l6 ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 81: {
                            l = l6 | l5;
                            break;
                        }
                        case 82: {
                            l = l6 ^ l5;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)l);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = null;
                if (this.funcType != 80) {
                    byArray3 = ((BinaryData)objectArray[1]).getBytes();
                }
                switch (this.funcType) {
                    case 78: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 79: {
                        byArray3 = BitMap.not(byArray3);
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 80: {
                        byArray = BitMap.not(byArray2);
                        break;
                    }
                    case 81: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 82: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 101: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                int n5 = 1;
                block160: for (int i = 1; i < 4; ++i) {
                    for (int j = n5; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        n5 = j + 1;
                        continue block160;
                    }
                }
                return ValuePool.getInt(n);
            }
            case 103: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 128: {
                if (objectArray[0] == null) {
                    return null;
                }
                BlobData blobData = (BlobData)objectArray[0];
                byte[] byArray = blobData.getBytes(session, 0L, (int)blobData.length(session));
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 132: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuffer stringBuffer = new StringBuffer(string.length() * n);
                while (n-- > 0) {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            case 133: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                if (string2.length() == 0) {
                    return string;
                }
                while (true) {
                    int n6;
                    if ((n6 = string.indexOf(string2, n)) == -1) break;
                    stringBuffer.append(string.substring(n, n6));
                    stringBuffer.append(string3);
                    n = n6 + string2.length();
                }
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            case 112: 
            case 135: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = ((Number)objectArray[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, objectArray[0], 0L, n, true, this.funcType == 135);
            }
            case 150: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 134: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer((String)objectArray[0]);
                stringBuffer = stringBuffer.reverse();
                return stringBuffer.toString();
            }
            case 129: 
            case 130: 
            case 131: {
                Object object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                Object object3 = this.pattern;
                if (object3 == null) {
                    object = (String)objectArray[1];
                    object3 = Pattern.compile((String)object);
                }
                object = ((Pattern)object3).matcher((String)objectArray[0]);
                switch (this.funcType) {
                    case 129: {
                        boolean bl = ((Matcher)object).matches();
                        return bl;
                    }
                    case 130: {
                        boolean bl = ((Matcher)object).find();
                        if (bl) {
                            return ((Matcher)object).group();
                        }
                        return null;
                    }
                    case 131: {
                        HsqlArrayList hsqlArrayList = new HsqlArrayList();
                        while (((Matcher)object).find()) {
                            hsqlArrayList.add(((Matcher)object).group());
                        }
                        return hsqlArrayList.toArray();
                    }
                }
            }
            case 87: {
                Object object3 = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString((byte[])object3);
            }
            case 113: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(string, (String)objectArray[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(string);
            }
            case 117: 
            case 138: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, objectArray[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)objectArray[0] : this.nodes[0].dataType.convertToString(objectArray[0]));
                int n = (Integer)Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].dataType);
                String string4 = " ";
                if (this.nodes[2] != null && (string4 = this.nodes[2].dataType.convertToString(objectArray[2])).length() == 0) {
                    string4 = " ";
                }
                string = (String)Type.SQL_VARCHAR.trim(session, string, ' ', true, true);
                string = StringUtil.toPaddedString(string, n, string4, this.funcType == 138);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, string, Type.SQL_VARCHAR);
                }
                return string;
            }
            case 125: {
                if (objectArray[1] == null) {
                    return null;
                }
                if (objectArray[2] == null) {
                    return null;
                }
                Object[] objectArray3 = (Object[])objectArray[1];
                ArrayType arrayType = (ArrayType)this.nodes[1].dataType;
                Type type = arrayType.collectionBaseType();
                int n = ((Number)Type.SQL_INTEGER.convertToType(session, objectArray[2], this.nodes[2].dataType)).intValue();
                if (n <= 0) {
                    throw Error.error(3403);
                }
                for (int i = --n; i < objectArray3.length; ++i) {
                    if (type.compare(session, objectArray[0], objectArray3[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 149: {
                if (objectArray[0] == null) {
                    return null;
                }
                ArrayType arrayType = (ArrayType)this.dataType;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                sortAndSlice.sortDescending[0] = ((Number)objectArray[1]).intValue() == 389;
                sortAndSlice.sortNullsLast[0] = ((Number)objectArray[2]).intValue() == 430;
                Object object = ArrayUtil.duplicateArray(objectArray[0]);
                arrayType.sort(session, object, sortAndSlice);
                return object;
            }
            case 73: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, timestampData, n);
            }
            case 98: {
                TimestampData timestampData = session.getSystemTimestamp(true);
                IntervalSecondData intervalSecondData = new IntervalSecondData(timestampData.getZone(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 102: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                return new TimestampData(timestampData.getSeconds() - intervalSecondData.getSeconds(), timestampData.getNanos(), (int)intervalSecondData.getSeconds());
            }
            case 111: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, objectArray[0]);
            }
            case 119: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)objectArray[0], (TimestampData)objectArray[1]);
            }
            case 120: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                IntervalSecondData intervalSecondData2 = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                Object object = Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(objectArray[0], Type.SQL_TIMESTAMP, (int)intervalSecondData2.getSeconds(), (int)intervalSecondData.getSeconds());
                return Type.SQL_TIMESTAMP.convertToType(session, object, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
            }
            case 121: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
            }
            case 122: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n7 = IntervalType.getFieldNameTypeForToken(n);
                switch (n7) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalSecondData.newInterval(d, n7);
            }
            case 123: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n8 = IntervalType.getFieldNameTypeForToken(n);
                switch (n8) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalMonthData.newInterval(d, n8);
            }
            case 145: {
                IntervalSecondData intervalSecondData = new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 152: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(objectArray[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, 0);
            }
            case 153: {
                TimestampData timestampData = session.getSystemTimestamp(false);
                return Type.SQL_TIMESTAMP_NO_FRACTION.convertToType(session, timestampData, Type.SQL_TIMESTAMP);
            }
            case 154: {
                return session.getSystemTimestamp(true);
            }
            case 163: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 164: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 167: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
            }
            case 171: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap intKeyIntValueHashMap = this.charLookup;
                if (intKeyIntValueHashMap == null) {
                    intKeyIntValueHashMap = this.getTranslationMap((String)objectArray[1], (String)objectArray[2]);
                }
                return this.translateWithMap((String)objectArray[0], intKeyIntValueHashMap);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, expression);
                return;
            }
            case 88: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 90: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 106: 
            case 108: 
            case 109: 
            case 110: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 89: 
            case 92: 
            case 107: 
            case 143: 
            case 168: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 91: 
            case 144: 
            case 160: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 104: 
            case 114: 
            case 142: 
            case 169: 
            case 170: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 100: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 141: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 95: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                n = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 158;
            }
            case 158: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 96: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(857), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    n = this.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(n);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 159;
            }
            case 159: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block66 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode == 92 || this.nodes[2].dataType.typeCode == 94) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 857: 
                            case 858: 
                            case 859: 
                            case 860: 
                            case 861: {
                                break block66;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode != 92 && this.nodes[2].dataType.typeCode != 94) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 93: 
            case 94: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 97: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 136: 
            case 172: {
                int n2;
                int n3 = n = this.nodes.length == 1 || this.nodes[1] == null ? 1 : 0;
                if (this.nodes[0].dataType == null) {
                    if (n != 0) {
                        if (expression instanceof ExpressionLogical || expression instanceof ExpressionArithmetic) {
                            for (n2 = 0; n2 < expression.nodes.length; ++n2) {
                                if (expression.nodes[n2].dataType == null) continue;
                                this.nodes[0].dataType = expression.nodes[n2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (n == 0 && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 173: {
                int n2;
                Number number = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    number = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        number = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (number != null) {
                    n2 = number;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > this.dataType.scale) {
                        n2 = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && n2 != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)n2, n2);
                    }
                }
                return;
            }
            case 161: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 165: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 162: 
            case 166: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = "DD-MON-YYYY HH24:MI:SS";
                    if (this.funcType == 166) {
                        string = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = this.funcType == 162 ? Type.SQL_TIMESTAMP_NO_FRACTION : Type.SQL_TIMESTAMP;
                return;
            }
            case 156: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 157: {
                Type type = this.nodes[0].dataType;
                if (type == null) {
                    type = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 124: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 174: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_16;
                    break;
                }
                throw Error.error(5563);
            }
            case 175: 
            case 176: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 127: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 75: 
            case 76: 
            case 85: 
            case 86: 
            case 99: 
            case 116: 
            case 126: 
            case 137: 
            case 147: 
            case 155: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 146: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 77: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 148: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.funcType == 80) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (n = 0; n < this.nodes.length; ++n) {
                        if (this.nodes[n].dataType != null) continue;
                        this.nodes[n].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 83: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 101: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 128: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 133: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 112: 
            case 135: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 150: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 134: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 129: 
            case 130: 
            case 131: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String string = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string);
                }
                switch (this.funcType) {
                    case 129: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break;
                    }
                    case 130: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break;
                    }
                    case 131: {
                        this.dataType = Type.getDefaultArrayType(12);
                    }
                }
                break;
            }
            case 87: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 113: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 117: 
            case 138: {
                Number number;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number.longValue());
                break;
            }
            case 125: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = ((ArrayType)this.nodes[1].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[1].dataType).collectionBaseType().typeComparisonGroup != this.nodes[0].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 149: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(338), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(401), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 98: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 102: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 111: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 119: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 121: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 145: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 152: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 153: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 154: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 163: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 164: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 167: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = "DD-MON-YYYY HH24:MI:SS:FF TZH:TZM";
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 171: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[n].dataType.isCharacterType() && !this.nodes[n].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = this.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer stringBuffer = new StringBuffer("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    stringBuffer.append(",").append(this.nodes[3].getSQL());
                }
                stringBuffer.append(")").toString();
                return stringBuffer.toString();
            }
            case 117: 
            case 138: {
                StringBuffer stringBuffer = new StringBuffer(this.name);
                stringBuffer.append("(").append(this.nodes[0].getSQL());
                stringBuffer.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuffer.append(",").append(this.nodes[2].getSQL());
                }
                stringBuffer.append(")").toString();
                return stringBuffer.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 125: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL()).append(' ').append("IN");
                stringBuffer.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    stringBuffer.append(' ').append("FROM");
                    stringBuffer.append(' ').append(this.nodes[2].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 149: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    stringBuffer.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 430) {
                    stringBuffer.append(' ').append("NULLS").append(' ');
                    stringBuffer.append("LAST");
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 153: 
            case 154: {
                return this.name;
            }
            case 72: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 124: 
            case 142: 
            case 143: 
            case 144: 
            case 160: 
            case 168: 
            case 169: 
            case 170: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 158: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 159: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 93: {
                return new StringBuffer(this.nodes[0].getSQL()).append(' ').append('+').append(this.nodes[1].getSQL()).toString();
            }
            case 94: {
                return new StringBuffer(this.nodes[0].getSQL()).append(' ').append('-').append(this.nodes[1].getSQL()).toString();
            }
            case 127: 
            case 175: 
            case 176: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    stringBuffer.append(this.nodes[0].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 113: 
            case 136: 
            case 156: 
            case 162: 
            case 165: 
            case 166: 
            case 167: 
            case 172: 
            case 173: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    stringBuffer.append(',').append(this.nodes[1].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 85: 
            case 86: 
            case 97: 
            case 99: 
            case 103: 
            case 114: 
            case 116: 
            case 126: 
            case 128: 
            case 134: 
            case 137: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 155: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 101: 
            case 112: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 135: 
            case 161: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 100: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append("ROW_COUNT");
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 133: 
            case 141: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
            case 73: 
            case 98: 
            case 102: 
            case 111: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 152: 
            case 163: 
            case 164: 
            case 171: {
                return this.getSQLSimple();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.nodes[i].getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static char[] soundex(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    int getTSIToken(String string) {
        int n;
        if ("yy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            n = 861;
        } else if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            n = 859;
        } else if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            n = 857;
        } else if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            n = 856;
        } else if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            n = 855;
        } else if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            n = 854;
        } else if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            n = 853;
        } else {
            throw Error.error(5566, string);
        }
        return n;
    }

    IntKeyIntValueHashMap getTranslationMap(String string, String string2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = new IntKeyIntValueHashMap();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i >= string2.length()) {
                intKeyIntValueHashMap.put(c, -1);
                continue;
            }
            char c2 = string2.charAt(i);
            intKeyIntValueHashMap.put(c, c2);
        }
        return intKeyIntValueHashMap;
    }

    String translateWithMap(String string, IntKeyIntValueHashMap intKeyIntValueHashMap) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = intKeyIntValueHashMap.get((int)c, -2);
            if (n == -2) {
                stringBuffer.append(c);
                continue;
            }
            if (n == -1) continue;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(87);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(91);
        nonDeterministicFuncSet.add(104);
        nonDeterministicFuncSet.add(106);
        nonDeterministicFuncSet.add(110);
        nonDeterministicFuncSet.add(108);
        nonDeterministicFuncSet.add(109);
        nonDeterministicFuncSet.add(107);
        nonDeterministicFuncSet.add(142);
        nonDeterministicFuncSet.add(143);
        nonDeterministicFuncSet.add(144);
        nonDeterministicFuncSet.add(145);
        nonDeterministicFuncSet.add(153);
        nonDeterministicFuncSet.add(154);
        nonDeterministicFuncSet.add(156);
        nonDeterministicFuncSet.add(160);
        nonDeterministicFuncSet.add(168);
        nonDeterministicFuncSet.add(169);
        nonDeterministicFuncSet.add(170);
        nonDeterministicFuncSet.add(174);
        nonDeterministicFuncSet.add(175);
        nonDeterministicFuncSet.add(176);
        customRegularFuncMap.put(640, 71);
        customRegularFuncMap.put(641, 72);
        customRegularFuncMap.put(644, 73);
        customRegularFuncMap.put(642, 149);
        customRegularFuncMap.put(643, 74);
        customRegularFuncMap.put(645, 75);
        customRegularFuncMap.put(646, 76);
        customRegularFuncMap.put(647, 77);
        customRegularFuncMap.put(649, 78);
        customRegularFuncMap.put(650, 79);
        customRegularFuncMap.put(651, 6);
        customRegularFuncMap.put(652, 80);
        customRegularFuncMap.put(653, 81);
        customRegularFuncMap.put(654, 82);
        customRegularFuncMap.put(33, 83);
        customRegularFuncMap.put(655, 83);
        customRegularFuncMap.put(656, 84);
        customRegularFuncMap.put(658, 85);
        customRegularFuncMap.put(659, 86);
        customRegularFuncMap.put(660, 87);
        customRegularFuncMap.put(661, 43);
        customRegularFuncMap.put(662, 51);
        customRegularFuncMap.put(582, 88);
        customRegularFuncMap.put(664, 90);
        customRegularFuncMap.put(663, 89);
        customRegularFuncMap.put(665, 91);
        customRegularFuncMap.put(666, 92);
        customRegularFuncMap.put(667, 93);
        customRegularFuncMap.put(668, 94);
        customRegularFuncMap.put(669, 95);
        customRegularFuncMap.put(670, 96);
        customRegularFuncMap.put(73, 5);
        customRegularFuncMap.put(675, 5);
        customRegularFuncMap.put(676, 5);
        customRegularFuncMap.put(677, 5);
        customRegularFuncMap.put(678, 5);
        customRegularFuncMap.put(679, 97);
        customRegularFuncMap.put(680, 98);
        customRegularFuncMap.put(682, 99);
        customRegularFuncMap.put(391, 100);
        customRegularFuncMap.put(683, 101);
        customRegularFuncMap.put(685, 102);
        customRegularFuncMap.put(686, 103);
        customRegularFuncMap.put(127, 5);
        customRegularFuncMap.put(128, 104);
        customRegularFuncMap.put(135, 32);
        customRegularFuncMap.put(690, 1);
        customRegularFuncMap.put(691, 106);
        customRegularFuncMap.put(692, 108);
        customRegularFuncMap.put(693, 109);
        customRegularFuncMap.put(694, 110);
        customRegularFuncMap.put(695, 107);
        customRegularFuncMap.put(697, 111);
        customRegularFuncMap.put(698, 26);
        customRegularFuncMap.put(153, 112);
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(700, 113);
        customRegularFuncMap.put(707, 114);
        customRegularFuncMap.put(701, 1);
        customRegularFuncMap.put(703, 14);
        customRegularFuncMap.put(704, 116);
        customRegularFuncMap.put(705, 117);
        customRegularFuncMap.put(706, 31);
        customRegularFuncMap.put(169, 5);
        customRegularFuncMap.put(173, 5);
        customRegularFuncMap.put(709, 5);
        customRegularFuncMap.put(710, 119);
        customRegularFuncMap.put(713, 120);
        customRegularFuncMap.put(717, 122);
        customRegularFuncMap.put(718, 123);
        customRegularFuncMap.put(719, 8);
        customRegularFuncMap.put(720, 124);
        customRegularFuncMap.put(721, 125);
        customRegularFuncMap.put(722, 5);
        customRegularFuncMap.put(723, 126);
        customRegularFuncMap.put(724, 127);
        customRegularFuncMap.put(725, 128);
        customRegularFuncMap.put(726, 129);
        customRegularFuncMap.put(727, 130);
        customRegularFuncMap.put(728, 131);
        customRegularFuncMap.put(234, 132);
        customRegularFuncMap.put(729, 133);
        customRegularFuncMap.put(730, 134);
        customRegularFuncMap.put(240, 135);
        customRegularFuncMap.put(731, 136);
        customRegularFuncMap.put(732, 137);
        customRegularFuncMap.put(734, 138);
        customRegularFuncMap.put(733, 31);
        customRegularFuncMap.put(250, 5);
        customRegularFuncMap.put(735, 5);
        customRegularFuncMap.put(736, 141);
        customRegularFuncMap.put(737, 142);
        customRegularFuncMap.put(738, 143);
        customRegularFuncMap.put(739, 144);
        customRegularFuncMap.put(740, 145);
        customRegularFuncMap.put(741, 146);
        customRegularFuncMap.put(742, 147);
        customRegularFuncMap.put(743, 149);
        customRegularFuncMap.put(744, 148);
        customRegularFuncMap.put(514, 150);
        customRegularFuncMap.put(756, 23);
        customRegularFuncMap.put(757, 152);
        customRegularFuncMap.put(758, 153);
        customRegularFuncMap.put(759, 154);
        customRegularFuncMap.put(760, 155);
        customRegularFuncMap.put(282, 156);
        customRegularFuncMap.put(761, 157);
        customRegularFuncMap.put(762, 158);
        customRegularFuncMap.put(763, 159);
        customRegularFuncMap.put(764, 160);
        customRegularFuncMap.put(765, 161);
        customRegularFuncMap.put(766, 162);
        customRegularFuncMap.put(767, 163);
        customRegularFuncMap.put(768, 164);
        customRegularFuncMap.put(769, 165);
        customRegularFuncMap.put(770, 166);
        customRegularFuncMap.put(774, 168);
        customRegularFuncMap.put(775, 169);
        customRegularFuncMap.put(776, 170);
        customRegularFuncMap.put(287, 171);
        customRegularFuncMap.put(777, 172);
        customRegularFuncMap.put(295, 173);
        customRegularFuncMap.put(779, 27);
        customRegularFuncMap.put(780, 176);
        customRegularFuncMap.put(781, 175);
        customRegularFuncMap.put(782, 174);
        customRegularFuncMap.put(790, 5);
        customRegularFuncMap.put(323, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(772, 43);
        customValueFuncMap.put(716, 52);
    }
}

