/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.Routine;
import org.evosuite.shaded.org.hsqldb.SchemaObject;
import org.evosuite.shaded.org.hsqldb.SchemaObjectSet;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.HashMappedList;
import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;
import org.evosuite.shaded.org.hsqldb.lib.Iterator;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;
import org.evosuite.shaded.org.hsqldb.lib.WrapperIterator;
import org.evosuite.shaded.org.hsqldb.rights.Grantee;

public final class Schema
implements SchemaObject {
    private HsqlNameManager.HsqlName name;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet typeLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet specificRoutineLookup;
    SchemaObjectSet assertionLookup;
    HashMappedList tableList;
    HashMappedList sequenceList;
    long changeTimestamp;

    public Schema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        this.name = hsqlName;
        this.triggerLookup = new SchemaObjectSet(8);
        this.indexLookup = new SchemaObjectSet(20);
        this.constraintLookup = new SchemaObjectSet(5);
        this.tableLookup = new SchemaObjectSet(3);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.typeLookup = new SchemaObjectSet(12);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.procedureLookup = new SchemaObjectSet(17);
        this.functionLookup = new SchemaObjectSet(16);
        this.specificRoutineLookup = new SchemaObjectSet(24);
        this.assertionLookup = new SchemaObjectSet(6);
        this.tableList = (HashMappedList)this.tableLookup.map;
        this.sequenceList = (HashMappedList)this.sequenceLookup.map;
        hsqlName.owner = grantee;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return this.name.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(this.getName().statementName).append(' ');
        stringBuffer.append("AUTHORIZATION").append(' ');
        stringBuffer.append(this.getOwner().getName().getStatementName());
        return stringBuffer.toString();
    }

    static String getSetSchemaSQL(HsqlNameManager.HsqlName hsqlName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(hsqlName.statementName);
        return stringBuffer.toString();
    }

    public String[] getSQLArray(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        String string = Schema.getSetSchemaSQL(this.name);
        hsqlArrayList.add(string);
        Object[] objectArray = this.sequenceLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.tableLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.functionLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.procedureLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.assertionLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        if (hsqlArrayList.size() == 1) {
            return new String[0];
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getSequenceRestartSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.sequenceLookup.map.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = stringArray.getRestartSQL();
            hsqlArrayList.add(string);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getTriggerSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.tableLookup.map.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            Object[] objectArray = stringArray.getTriggerSQL();
            hsqlArrayList.addAll(objectArray);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public void addSimpleObjects(OrderedHashSet orderedHashSet) {
        Iterator iterator = this.specificRoutineLookup.map.values().iterator();
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            if (routine.dataImpact != 1 && routine.dataImpact != 2) continue;
            orderedHashSet.add(routine);
        }
        orderedHashSet.addAll(this.typeLookup.map.values());
        orderedHashSet.addAll(this.charsetLookup.map.values());
        orderedHashSet.addAll(this.collationLookup.map.values());
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRoutineLookup.isEmpty();
    }

    public SchemaObjectSet getObjectSet(int n) {
        switch (n) {
            case 7: {
                return this.sequenceLookup;
            }
            case 3: 
            case 4: {
                return this.tableLookup;
            }
            case 14: {
                return this.charsetLookup;
            }
            case 15: {
                return this.collationLookup;
            }
            case 17: {
                return this.procedureLookup;
            }
            case 16: {
                return this.functionLookup;
            }
            case 18: {
                return this.functionLookup;
            }
            case 24: {
                return this.specificRoutineLookup;
            }
            case 12: 
            case 13: {
                return this.typeLookup;
            }
            case 6: {
                return this.assertionLookup;
            }
            case 8: {
                return this.triggerLookup;
            }
            case 20: {
                return this.indexLookup;
            }
            case 5: {
                return this.constraintLookup;
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    Iterator schemaObjectIterator(int n) {
        switch (n) {
            case 7: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.map.values().iterator();
            }
            case 14: {
                return this.charsetLookup.map.values().iterator();
            }
            case 15: {
                return this.collationLookup.map.values().iterator();
            }
            case 17: {
                return this.procedureLookup.map.values().iterator();
            }
            case 16: {
                return this.functionLookup.map.values().iterator();
            }
            case 18: {
                Iterator iterator = this.functionLookup.map.values().iterator();
                return new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
            }
            case 24: {
                return this.specificRoutineLookup.map.values().iterator();
            }
            case 12: 
            case 13: {
                return this.typeLookup.map.values().iterator();
            }
            case 6: {
                return this.assertionLookup.map.values().iterator();
            }
            case 8: {
                return this.triggerLookup.map.values().iterator();
            }
            case 20: {
                return this.indexLookup.map.values().iterator();
            }
            case 5: {
                return this.constraintLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    void release() {
        for (int i = 0; i < this.tableList.size(); ++i) {
            Table table = (Table)this.tableList.get(i);
            table.terminateTriggers();
        }
        this.tableList.clear();
        this.sequenceList.clear();
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
    }
}

