/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.StatementDML;
import org.evosuite.shaded.org.hsqldb.lib.IntKeyHashMap;
import org.evosuite.shaded.org.hsqldb.lib.LongKeyHashMap;
import org.evosuite.shaded.org.hsqldb.lib.LongKeyIntValueHashMap;
import org.evosuite.shaded.org.hsqldb.lib.LongValueHashMap;
import org.evosuite.shaded.org.hsqldb.result.Result;

public final class StatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap csidMap;
    private LongKeyIntValueHashMap useMap;
    private long next_cs_id;

    StatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.useMap = new LongKeyIntValueHashMap();
        this.next_cs_id = 0L;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.csidMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(HsqlNameManager.HsqlName hsqlName, String string) {
        LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(hsqlName.hashCode());
        if (longValueHashMap == null) {
            return -1L;
        }
        return longValueHashMap.get((Object)string, -1);
    }

    public synchronized Statement getStatement(Session session, long l) {
        Statement statement = (Statement)this.csidMap.get(l);
        if (statement == null) {
            return null;
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            if ((statement = this.recompileStatement(session, statement)) == null) {
                this.freeStatement(l);
                return null;
            }
            this.csidMap.put(l, statement);
        }
        return statement;
    }

    public synchronized Statement getStatement(Session session, Statement statement) {
        long l = statement.getID();
        Statement statement2 = (Statement)this.csidMap.get(l);
        if (statement2 != null) {
            return this.getStatement(session, l);
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp() && (statement2 = this.recompileStatement(session, statement)) == null) {
            this.freeStatement(l);
            return null;
        }
        return statement2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Session session, Statement statement) {
        Statement statement2;
        HsqlNameManager.HsqlName hsqlName = session.getCurrentSchemaHsqlName();
        try {
            HsqlNameManager.HsqlName hsqlName2 = statement.getSchemaName();
            int n = statement.getCursorPropertiesRequest();
            if (hsqlName2 != null) {
                session.setSchema(hsqlName2.name);
            }
            boolean bl = statement.generatedResultMetaData() != null;
            statement2 = session.compileStatement(statement.getSQL(), n);
            statement2.setCursorPropertiesRequest(n);
            if (!statement.getResultMetaData().areTypesCompatible(statement2.getResultMetaData())) {
                Statement statement3 = null;
                return statement3;
            }
            if (!statement.getParametersMetaData().areTypesCompatible(statement2.getParametersMetaData())) {
                Statement statement4 = null;
                return statement4;
            }
            statement2.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            if (bl) {
                StatementDML statementDML = (StatementDML)statement;
                statement2.setGeneratedColumnInfo(statementDML.generatedType, statementDML.generatedInputMetaData);
            }
        }
        catch (Throwable throwable) {
            Statement statement5 = null;
            return statement5;
        }
        finally {
            session.setCurrentSchemaHsqlName(hsqlName);
        }
        return statement2;
    }

    private long registerStatement(long l, Statement statement) {
        if (l < 0L) {
            l = this.nextID();
            int n = statement.getSchemaName().hashCode();
            LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(n);
            if (longValueHashMap == null) {
                longValueHashMap = new LongValueHashMap();
                this.schemaMap.put(n, longValueHashMap);
            }
            longValueHashMap.put(statement.getSQL(), l);
        }
        statement.setID(l);
        statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(l, statement);
        return l;
    }

    synchronized void freeStatement(long l) {
        if (l == -1L) {
            return;
        }
        int n = this.useMap.get(l, 1);
        if (n > 1) {
            this.useMap.put(l, n - 1);
            return;
        }
        Statement statement = (Statement)this.csidMap.remove(l);
        if (statement != null) {
            int n2 = statement.getSchemaName().hashCode();
            LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(n2);
            String string = statement.getSQL();
            longValueHashMap.remove(string);
        }
        this.useMap.remove(l);
    }

    synchronized Statement compile(Session session, Result result) throws Throwable {
        int n = result.getExecuteProperties();
        Statement statement = null;
        String string = result.getMainString();
        long l = this.getStatementID(session.currentSchema, string);
        if (l >= 0L && (statement = (Statement)this.csidMap.get(l)) != null && statement.getCursorPropertiesRequest() != n) {
            statement = null;
            l = -1L;
        }
        if (statement == null || !statement.isValid() || statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            statement = session.compileStatement(string, n);
            statement.setCursorPropertiesRequest(n);
            l = this.registerStatement(l, statement);
        }
        int n2 = this.useMap.get(l, 0) + 1;
        this.useMap.put(l, n2);
        statement.setGeneratedColumnInfo(result.getGeneratedResultType(), result.getGeneratedResultMetaData());
        return statement;
    }
}

