/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.RowAction;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TransactionManager;
import org.evosuite.shaded.org.hsqldb.TransactionManagerCommon;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.persist.CachedObject;
import org.evosuite.shaded.org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database database) {
        this.database = database;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    @Override
    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int n = session.rowActionList.size();
            session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < n; ++i) {
                RowAction rowAction = (RowAction)session.rowActionList.get(i);
                rowAction.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.transactionEndTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        this.writeLock.lock();
        try {
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartTimestamp);
        this.endActionTPL(session);
    }

    @Override
    public void rollbackPartial(Session session, int n, long l) {
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            rowAction.rollback(session, l);
            int n3 = rowAction.mergeRollback(session, l, row);
            rowAction.store.rollbackRow(session, row, n3, this.txModel);
        }
        session.rowActionList.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction;
        Row row2 = row;
        synchronized (row2) {
            rowAction = RowAction.addDeleteAction(session, table, row, nArray);
        }
        session.rowActionList.add(rowAction);
        persistentStore.delete(session, row);
        row.rowAction = null;
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        persistentStore.indexRow(session, row);
        session.rowActionList.add(rowAction);
        row.rowAction = null;
    }

    @Override
    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n, int[] nArray) {
        return true;
    }

    @Override
    public boolean canRead(Session session, PersistentStore persistentStore, long l, int n) {
        return true;
    }

    @Override
    public void addTransactionInfo(CachedObject cachedObject) {
    }

    @Override
    public void setTransactionInfo(PersistentStore persistentStore, CachedObject cachedObject) {
    }

    @Override
    public void removeTransactionInfo(CachedObject cachedObject) {
    }

    @Override
    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        if (session.hasLocks(statement)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean bl;
            if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = statement = session.statementManager.getStatement(session, statement);
                if (statement == null) {
                    return;
                }
            }
            if (bl = this.setWaitedSessionsTPL(session, statement)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        session.actionStartTimestamp = session.actionTimestamp = this.getNextGlobalChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    @Override
    public void removeTransactionInfo(long l) {
    }

    @Override
    public void resetSession(Session session, Session session2, int n) {
        super.resetSession(session, session2, n);
    }

    void endTransaction(Session session) {
        if (session.isTransaction) {
            session.isTransaction = false;
            --this.transactionCount;
        }
    }
}

