/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.RowAction;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.SqlInvariants;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.TransactionManager2PL;
import org.evosuite.shaded.org.hsqldb.TransactionManagerMV2PL;
import org.evosuite.shaded.org.hsqldb.TransactionManagerMVCC;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.lib.HashMap;
import org.evosuite.shaded.org.hsqldb.lib.Iterator;
import org.evosuite.shaded.org.hsqldb.lib.LongDeque;
import org.evosuite.shaded.org.hsqldb.lib.LongKeyHashMap;
import org.evosuite.shaded.org.hsqldb.lib.MultiValueHashMap;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;

class TransactionManagerCommon {
    Database database;
    Session lobSession;
    int txModel;
    HsqlNameManager.HsqlName[] catalogNameList;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong(1L);
    int transactionCount = 0;
    HashMap tableWriteLocks = new HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();
    public LongKeyHashMap rowActionMap;

    TransactionManagerCommon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransactionControl(Session session, int n) {
        TransactionManagerCommon transactionManagerCommon = null;
        if (n == this.txModel) {
            return;
        }
        this.writeLock.lock();
        try {
            switch (this.txModel) {
                case 1: 
                case 2: {
                    if (this.liveTransactionTimestamps.size() == 1) break;
                    throw Error.error(3701);
                }
            }
            switch (n) {
                case 2: {
                    transactionManagerCommon = new TransactionManagerMVCC(this.database);
                    transactionManagerCommon.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    break;
                }
                case 1: {
                    transactionManagerCommon = new TransactionManagerMV2PL(this.database);
                    transactionManagerCommon.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    break;
                }
                case 0: {
                    transactionManagerCommon = new TransactionManager2PL(this.database);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "TransactionManagerCommon");
                }
            }
            transactionManagerCommon.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
            transactionManagerCommon.transactionCount = this.transactionCount;
            this.database.txManager = transactionManagerCommon;
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void adjustLobUsage(Session session) {
        int n;
        int n2 = session.rowActionList.size();
        long l = session.actionTimestamp;
        block4: for (n = 0; n < n2; ++n) {
            RowAction rowAction = (RowAction)session.rowActionList.get(n);
            if (rowAction.type == 0 || !rowAction.table.hasLobColumn) continue;
            int n3 = rowAction.getCommitTypeOn(l);
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            switch (n3) {
                case 1: {
                    session.sessionData.adjustLobUsageCount(rowAction.table, row.getData(), 1);
                    continue block4;
                }
                case 2: {
                    session.sessionData.adjustLobUsageCount(rowAction.table, row.getData(), -1);
                    continue block4;
                }
            }
        }
        n = session.rowActionList.size();
        if (n > n2) {
            for (int i = n2; i < n; ++i) {
                RowAction rowAction = (RowAction)session.rowActionList.get(i);
                rowAction.commit(session);
            }
        }
    }

    void persistCommit(Session session) {
        int n = session.rowActionList.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i);
            if (rowAction.type == 0) continue;
            int n2 = rowAction.getCommitTypeOn(session.actionTimestamp);
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (rowAction.table.tableType != 3) {
                bl = true;
            }
            try {
                rowAction.store.commitRow(session, row, n2, this.txModel);
                if (this.txModel != 0 && rowAction.table.tableType != 3) continue;
                rowAction.setAsNoOp();
                row.rowAction = null;
                continue;
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logWarningEvent("data commit failed", hsqlException);
            }
        }
        try {
            if (n > 0 && bl) {
                this.database.logger.writeCommitStatement(session);
            }
        }
        catch (HsqlException hsqlException) {
            this.database.logger.logWarningEvent("data commit failed", hsqlException);
        }
    }

    void finaliseRows(Session session, Object[] objectArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            this.postCommitAction(session, rowAction);
        }
    }

    void postCommitAction(Session session, RowAction rowAction) {
        if (rowAction.type == 0) {
            rowAction.store.postCommitAction(session, rowAction);
        }
        if (rowAction.type == 3 && !rowAction.deleteComplete) {
            try {
                rowAction.deleteComplete = true;
                if (rowAction.table.getTableType() == 3) {
                    return;
                }
                Row row = rowAction.memoryRow;
                if (row == null) {
                    row = (Row)rowAction.store.get(rowAction.getPos(), false);
                }
                rowAction.store.commitRow(session, row, rowAction.type, this.txModel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void mergeTransaction(Object[] objectArray, int n, int n2, long l) {
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            rowAction.mergeToTimestamp(l);
        }
    }

    public long getNextGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    boolean checkDeadlock(Session session, OrderedHashSet orderedHashSet) {
        int n = session.waitingSessions.size();
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            if (orderedHashSet.contains(session2)) {
                return false;
            }
            if (this.checkDeadlock(session2, orderedHashSet)) continue;
            return false;
        }
        return true;
    }

    boolean checkDeadlock(Session session, Session session2) {
        int n = session.waitingSessions.size();
        for (int i = 0; i < n; ++i) {
            Session session3 = (Session)session.waitingSessions.get(i);
            if (session3 == session2) {
                return false;
            }
            if (this.checkDeadlock(session3, session2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endActionTPL(Session session) {
        if (session.isolationLevel == 4 || session.isolationLevel == 8) {
            return;
        }
        if (session.sessionContext.currentStatement == null) {
            return;
        }
        if (session.sessionContext.depth > 0) {
            return;
        }
        Object[] objectArray = session.sessionContext.currentStatement.getTableNamesForRead();
        if (objectArray.length == 0) {
            return;
        }
        this.writeLock.lock();
        try {
            int n;
            this.unlockReadTablesTPL(session, (HsqlNameManager.HsqlName[])objectArray);
            int n2 = session.waitingSessions.size();
            if (n2 == 0) {
                return;
            }
            boolean bl = false;
            for (n = 0; n < objectArray.length; ++n) {
                if (this.tableWriteLocks.get(objectArray[n]) == session) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            bl = false;
            for (n = 0; n < n2; ++n) {
                Session session2 = (Session)session.waitingSessions.get(n);
                if (session2.abortTransaction) {
                    bl = true;
                    break;
                }
                Statement statement = session2.sessionContext.currentStatement;
                if (statement == null) {
                    bl = true;
                    break;
                }
                if (!ArrayUtil.containsAny(objectArray, statement.getTableNamesForWrite())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            this.resetLocks(session);
            this.resetLatchesMidTransaction(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransactionTPL(Session session) {
        this.unlockTablesTPL(session);
        int n = session.waitingSessions.size();
        if (n == 0) {
            return;
        }
        this.resetLocks(session);
        this.resetLatches(session);
    }

    void resetLocks(Session session) {
        Session session2;
        int n;
        int n2 = session.waitingSessions.size();
        for (n = 0; n < n2; ++n) {
            boolean bl;
            session2 = (Session)session.waitingSessions.get(n);
            session2.tempUnlocked = false;
            long l = session2.latch.getCount();
            if (l != 1L || !(bl = this.setWaitedSessionsTPL(session2, session2.sessionContext.currentStatement)) || !session2.tempSet.isEmpty()) continue;
            this.lockTablesTPL(session2, session2.sessionContext.currentStatement);
            session2.tempUnlocked = true;
        }
        for (n = 0; n < n2; ++n) {
            session2 = (Session)session.waitingSessions.get(n);
            if (session2.tempUnlocked || session2.abortTransaction) continue;
            this.setWaitedSessionsTPL(session2, session2.sessionContext.currentStatement);
        }
    }

    void resetLatches(Session session) {
        int n = session.waitingSessions.size();
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            this.setWaitingSessionTPL(session2);
        }
        session.waitingSessions.clear();
        session.latch.setCount(0);
    }

    void resetLatchesMidTransaction(Session session) {
        session.tempSet.clear();
        session.tempSet.addAll(session.waitingSessions);
        session.waitingSessions.clear();
        int n = session.tempSet.size();
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.tempSet.get(i);
            if (session2.abortTransaction || session2.tempSet.isEmpty()) {
                // empty if block
            }
            this.setWaitingSessionTPL(session2);
        }
        session.tempSet.clear();
    }

    boolean setWaitedSessionsTPL(Session session, Statement statement) {
        Session session2;
        HsqlNameManager.HsqlName hsqlName;
        int n;
        session.tempSet.clear();
        if (statement == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session2 = (Session)this.tableWriteLocks.get(hsqlName);
            if (session2 != null && session2 != session) {
                session.tempSet.add(session2);
            }
            Iterator iterator = this.tableReadLocks.get(hsqlName);
            while (iterator.hasNext()) {
                session2 = (Session)iterator.next();
                if (session2 == session) continue;
                session.tempSet.add(session2);
            }
        }
        hsqlNameArray = statement.getTableNamesForRead();
        if (this.txModel == 1 && session.isReadOnly()) {
            hsqlNameArray = this.catalogNameList;
        }
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (session2 = (Session)this.tableWriteLocks.get(hsqlName)) == null || session2 == session) continue;
            session.tempSet.add(session2);
        }
        if (session.tempSet.isEmpty()) {
            return true;
        }
        if (this.checkDeadlock(session, session.tempSet)) {
            return true;
        }
        session.tempSet.clear();
        session.abortTransaction = true;
        return false;
    }

    void setWaitingSessionTPL(Session session) {
        int n = session.tempSet.size();
        assert (session.latch.getCount() <= (long)(n + 1));
        for (int i = 0; i < n; ++i) {
            Session session2 = (Session)session.tempSet.get(i);
            session2.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(n);
    }

    void lockTablesTPL(Session session, Statement statement) {
        HsqlNameManager.HsqlName hsqlName;
        int n;
        if (statement == null || session.abortTransaction) {
            return;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableWriteLocks.put(hsqlName, session);
        }
        hsqlNameArray = statement.getTableNamesForRead();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableReadLocks.put(hsqlName, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session session2;
        Iterator iterator = this.tableWriteLocks.values().iterator();
        while (iterator.hasNext()) {
            session2 = (Session)iterator.next();
            if (session2 != session) continue;
            iterator.remove();
        }
        iterator = this.tableReadLocks.values().iterator();
        while (iterator.hasNext()) {
            session2 = (Session)iterator.next();
            if (session2 != session) continue;
            iterator.remove();
        }
    }

    void unlockReadTablesTPL(Session session, HsqlNameManager.HsqlName[] hsqlNameArray) {
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            this.tableReadLocks.remove(hsqlNameArray[i], session);
        }
    }

    boolean hasLocks(Session session, Statement statement) {
        Session session2;
        HsqlNameManager.HsqlName hsqlName;
        int n;
        if (statement == null) {
            return true;
        }
        HsqlNameManager.HsqlName[] hsqlNameArray = statement.getTableNamesForWrite();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session2 = (Session)this.tableWriteLocks.get(hsqlName);
            if (session2 != null && session2 != session) {
                return false;
            }
            Iterator iterator = this.tableReadLocks.get(hsqlName);
            while (iterator.hasNext()) {
                session2 = (Session)iterator.next();
                if (session2 == session) continue;
                return false;
            }
        }
        hsqlNameArray = statement.getTableNamesForRead();
        for (n = 0; n < hsqlNameArray.length; ++n) {
            hsqlName = hsqlNameArray[n];
            if (hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (session2 = (Session)this.tableWriteLocks.get(hsqlName)) == null || session2 == session) continue;
            return false;
        }
        return true;
    }

    long getFirstLiveTransactionTimestamp() {
        if (this.liveTransactionTimestamps.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.liveTransactionTimestamps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        this.writeLock.lock();
        try {
            var1_1 = this.database.sessionManager.getAllSessions();
            var2_2 = new int[var1_1.length];
            var3_3 = 0;
            var4_4 = 0;
            for (var5_6 = 0; var5_6 < var1_1.length; ++var5_6) {
                var4_4 += var1_1[var5_6].getTransactionSize();
            }
            var6_7 = new RowAction[var4_4];
            block4: while (true) {
                var4_4 = 0;
                var7_8 = 0x7FFFFFFFFFFFFFFFL;
                var9_9 = 0;
                for (var10_11 = 0; var10_11 < var1_1.length; ++var10_11) {
                    var11_12 = var1_1[var10_11].getTransactionSize();
                    if (var2_2[var10_11] >= var11_12) continue;
                    var12_14 = (RowAction)var1_1[var10_11].rowActionList.get(var2_2[var10_11]);
                    if (var12_14.actionTimestamp < var7_8) {
                        var7_8 = var12_14.actionTimestamp;
                        var9_9 = var10_11;
                    }
                    var4_4 = 1;
                }
                if (var4_4 == 0) break;
                var10_10 = var1_1[var9_9].rowActionList;
                while (true) {
                    if (var2_2[var9_9] >= var10_10.size()) continue block4;
                    var11_13 = (RowAction)var10_10.get(var2_2[var9_9]);
                    if (var11_13.actionTimestamp == var7_8 + 1L) {
                        ++var7_8;
                    }
                    if (var11_13.actionTimestamp == var7_8) ** break;
                    continue block4;
                    var6_7[var3_3++] = var11_13;
                    v0 = var9_9;
                    var2_2[v0] = var2_2[v0] + 1;
                }
                break;
            }
            var4_5 = var6_7;
            return var4_5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resetSession(Session session, Session session2, int n) {
        if (session == session2) {
            return;
        }
        this.writeLock.lock();
        try {
            switch (n) {
                case 1: {
                    if (session2.isInMidTransaction()) return;
                    session2.sessionData.closeAllNavigators();
                    return;
                }
                case 2: {
                    if (session2.isInMidTransaction()) return;
                    session2.sessionData.persistentStoreCollection.clearAllTables();
                    return;
                }
                case 3: {
                    if (session2.isInMidTransaction()) return;
                    session2.resetSession();
                    return;
                }
                case 4: {
                    if (session2.latch.getCount() > 0L) {
                        session2.abortTransaction = true;
                        session2.latch.setCount(0);
                        return;
                    }
                    session2.rollbackNoCheck(true);
                    return;
                }
                case 5: {
                    if (session2.latch.getCount() != 0L) return;
                    session2.rollbackNoCheck(true);
                    session2.close();
                    return;
                }
            }
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

