/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.evosuite.shaded.org.hsqldb.auth.AuthFunctionBean;
import org.evosuite.shaded.org.hsqldb.auth.DenyException;
import org.evosuite.shaded.org.hsqldb.lib.FrameworkLogger;

public class LdapAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(LdapAuthBean.class);
    private Integer ldapPort;
    private String ldapHost;
    private String principalTemplate;
    private String saslRealm;
    private String parentDn;
    private Pattern roleSchemaValuePattern;
    private Pattern accessValuePattern;
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private boolean tls;
    private String mechanism = "SIMPLE";
    private String rdnAttribute = "uid";
    private boolean initialized;
    private String rolesSchemaAttribute;
    private String accessAttribute;
    protected String[] attributeUnion;

    public void setStartTls(boolean bl) {
        this.tls = bl;
    }

    public void setLdapPort(int n) {
        this.ldapPort = n;
    }

    public void init() {
        if (this.ldapHost == null) {
            throw new IllegalStateException("Required property 'ldapHost' not set");
        }
        if (this.parentDn == null) {
            throw new IllegalStateException("Required property 'parentDn' not set");
        }
        if (this.initialContextFactory == null) {
            throw new IllegalStateException("Required property 'initialContextFactory' not set");
        }
        if (this.mechanism == null) {
            throw new IllegalStateException("Required property 'mechanism' not set");
        }
        if (this.rdnAttribute == null) {
            throw new IllegalStateException("Required property 'rdnAttribute' not set");
        }
        if (this.rolesSchemaAttribute == null && this.accessAttribute == null) {
            throw new IllegalStateException("You must set property 'rolesSchemaAttribute' and/or property 'accessAttribute'");
        }
        if (this.roleSchemaValuePattern != null && this.rolesSchemaAttribute == null) {
            throw new IllegalStateException("If property 'roleSchemaValuePattern' is set, then you must also set property 'rolesSchemaAttribute' to indicate which attribute to evalueate");
        }
        if (this.accessValuePattern != null && this.accessAttribute == null) {
            throw new IllegalStateException("If property 'accessValuePattern' is set, then you must also set property 'accessAttribute' to indicate which attribute to evalueate");
        }
        this.attributeUnion = this.rolesSchemaAttribute != null && this.accessAttribute != null ? new String[]{this.rolesSchemaAttribute, this.accessAttribute} : (this.rolesSchemaAttribute != null ? new String[]{this.rolesSchemaAttribute} : new String[]{this.accessAttribute});
        this.initialized = true;
    }

    public void setAccessValuePattern(Pattern pattern) {
        this.accessValuePattern = pattern;
    }

    public void setAccessValuePatternString(String string) {
        this.setAccessValuePattern(Pattern.compile(string));
    }

    public void setRoleSchemaValuePattern(Pattern pattern) {
        this.roleSchemaValuePattern = pattern;
    }

    public void setRoleSchemaValuePatternString(String string) {
        this.setRoleSchemaValuePattern(Pattern.compile(string));
    }

    public void setSecurityMechanism(String string) {
        this.mechanism = string;
    }

    public void setLdapHost(String string) {
        this.ldapHost = string;
    }

    public void setPrincipalTemplate(String string) {
        this.principalTemplate = string;
    }

    public void setInitialContextFactory(String string) {
        this.initialContextFactory = string;
    }

    public void setSaslRealm(String string) {
        this.saslRealm = string;
    }

    public void setParentDn(String string) {
        this.parentDn = string;
    }

    public void setRdnAttribute(String string) {
        this.rdnAttribute = string;
    }

    public void setRolesSchemaAttribute(String string) {
        this.rolesSchemaAttribute = string;
    }

    public void setAccessAttribute(String string) {
        this.accessAttribute = string;
    }

    @Override
    public String[] authenticate(String string, String string2) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + LdapAuthBean.class.getName() + " instance.");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5, 0.75f);
        hashtable.put("java.naming.factory.initial", this.initialContextFactory);
        hashtable.put("java.naming.provider.url", "ldap://" + this.ldapHost + (this.ldapPort == null ? "" : ":" + this.ldapPort));
        StartTlsResponse startTlsResponse = null;
        InitialLdapContext initialLdapContext = null;
        try {
            Object object;
            Cloneable cloneable;
            initialLdapContext = new InitialLdapContext(hashtable, null);
            if (this.tls) {
                startTlsResponse = (StartTlsResponse)initialLdapContext.extendedOperation(new StartTlsRequest());
                startTlsResponse.negotiate();
            }
            initialLdapContext.addToEnvironment("java.naming.security.authentication", this.mechanism);
            initialLdapContext.addToEnvironment("java.naming.security.principal", this.principalTemplate == null ? string : this.principalTemplate.replace("${username}", string));
            initialLdapContext.addToEnvironment("java.naming.security.credentials", string2);
            if (this.saslRealm != null) {
                hashtable.put("java.naming.security.sasl.realm", this.saslRealm);
            }
            NamingEnumeration<SearchResult> namingEnumeration = null;
            try {
                namingEnumeration = initialLdapContext.search(this.parentDn, (Attributes)new BasicAttributes(this.rdnAttribute, string), this.attributeUnion);
            }
            catch (AuthenticationException authenticationException) {
                throw new DenyException();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (!namingEnumeration.hasMore()) {
                throw new DenyException();
            }
            SearchResult searchResult = namingEnumeration.next();
            if (namingEnumeration.hasMore()) {
                throw new RuntimeException("> 1 result");
            }
            Attributes attributes = searchResult.getAttributes();
            if (this.accessAttribute != null) {
                cloneable = attributes.get(this.accessAttribute);
                if (cloneable == null) {
                    throw new DenyException();
                }
                if (cloneable.size() != 1) {
                    throw new RuntimeException("Access attribute '" + this.accessAttribute + "' has unexpected value count: " + cloneable.size());
                }
                if (this.accessValuePattern != null) {
                    object = cloneable.get(0);
                    if (object == null) {
                        throw new RuntimeException("Access Attr. value is null");
                    }
                    if (!(object instanceof String)) {
                        throw new RuntimeException("Access Attr. value not a String: " + object.getClass().getName());
                    }
                    if (!this.accessValuePattern.matcher((String)object).matches()) {
                        throw new DenyException();
                    }
                }
            }
            if (this.rolesSchemaAttribute == null) {
                cloneable = null;
                return cloneable;
            }
            cloneable = new ArrayList();
            object = attributes.get(this.rolesSchemaAttribute);
            if (object != null) {
                int n = object.size();
                for (int i = 0; i < n; ++i) {
                    Object object2 = object.get(i);
                    if (object2 == null) {
                        throw new RuntimeException("R/S Attr value #" + i + " is null");
                    }
                    if (!(object2 instanceof String)) {
                        throw new RuntimeException("R/S Attr value #" + i + " not a String: " + object2.getClass().getName());
                    }
                    if (this.roleSchemaValuePattern == null) {
                        cloneable.add((String)object2);
                        continue;
                    }
                    Matcher matcher = this.roleSchemaValuePattern.matcher((String)object2);
                    if (!matcher.matches()) continue;
                    cloneable.add(matcher.groupCount() > 0 ? matcher.group(1) : (String)object2);
                }
            }
            if (cloneable.size() < 1) {
                if (this.accessAttribute == null) {
                    throw new DenyException();
                }
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = cloneable.toArray(new String[0]);
            return stringArray;
        }
        catch (DenyException denyException) {
            throw denyException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (NamingException namingException) {
            throw new RuntimeException(namingException);
        }
        finally {
            if (startTlsResponse != null) {
                try {
                    startTlsResponse.close();
                }
                catch (IOException iOException) {
                    logger.error("Failed to close TLS Response", iOException);
                }
            }
            if (initialLdapContext != null) {
                try {
                    initialLdapContext.close();
                }
                catch (NamingException namingException) {
                    logger.error("Failed to close LDAP Context", namingException);
                }
            }
        }
    }
}

