/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.lib.KMPSearchAlgorithm;
import org.evosuite.shaded.org.hsqldb.lib.java.JavaSystem;

public class JDBCBlob
implements Blob {
    public static final long MIN_POS = 1L;
    public static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private byte[] m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray = this.getData();
        int n2 = byArray.length;
        if (l < 1L || l > 1L + (long)n2) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (n < 0 || (long)n > (long)n2 - --l) {
            throw JDBCUtil.outOfRangeArgument("length: " + n);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, (int)l, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getData());
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        byte[] byArray2 = this.getData();
        int n = byArray2.length;
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (l > (long)n || byArray == null) {
            return -1L;
        }
        int n2 = (int)l - 1;
        int n3 = byArray.length;
        if (n3 == 0 || n2 > n - n3) {
            return -1L;
        }
        int n4 = KMPSearchAlgorithm.search(byArray2, byArray, KMPSearchAlgorithm.computeTable(byArray), n2);
        return n4 == -1 ? -1L : (long)(n4 + 1);
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = this.getData();
        int n = byArray.length;
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (l > (long)n || blob == null) {
            return -1L;
        }
        int n2 = (int)l - 1;
        long l2 = blob.length();
        if (l2 == 0L || (long)n2 > (long)n - l2) {
            return -1L;
        }
        int n3 = (int)l2;
        byte[] byArray2 = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, n3);
        int n4 = KMPSearchAlgorithm.search(byArray, byArray2, KMPSearchAlgorithm.computeTable(byArray2), n2);
        return n4 == -1 ? -1L : (long)(n4 + 1);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        if (byArray == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        if (n < 0 || n > byArray.length) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n);
        }
        if (n2 > byArray.length - n) {
            throw JDBCUtil.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L || l > 1L + (long)(Integer.MAX_VALUE - n2)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        byte[] byArray2 = this.getData();
        int n3 = byArray2.length;
        if (--l + (long)n2 > (long)n3) {
            byte[] byArray3 = new byte[(int)l + n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            byArray2 = byArray3;
            byArray3 = null;
        }
        System.arraycopy(byArray, n, byArray2, (int)l, n2);
        this.checkClosed();
        this.setData(byArray2);
        return n2;
    }

    @Override
    public OutputStream setBinaryStream(final long l) throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        if (l < 1L || l > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        this.checkClosed();
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCBlob.this.setBytes(l, this.toByteArray());
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long l) throws SQLException {
        byte[] byArray = this.getData();
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        if (l < 0L || l > (long)byArray.length) {
            throw JDBCUtil.outOfRangeArgument("len: " + l);
        }
        if (l == (long)byArray.length) {
            return;
        }
        byte[] byArray2 = new byte[(int)l];
        System.arraycopy(byArray, 0, byArray2, 0, (int)l);
        this.checkClosed();
        this.setData(byArray2);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        byte[] byArray = this.getData();
        int n = byArray.length;
        if (l < 1L || l > (long)n) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (l2 < 0L || l2 > (long)n - --l) {
            throw JDBCUtil.outOfRangeArgument("length: " + l2);
        }
        if (l == 0L && l2 == (long)n) {
            return new ByteArrayInputStream(byArray);
        }
        byte[] byArray2 = new byte[(int)l2];
        System.arraycopy(byArray, (int)l, byArray2, 0, (int)l2);
        return new ByteArrayInputStream(byArray2);
    }

    public JDBCBlob(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw JDBCUtil.nullArgument();
        }
        this.m_data = byArray;
        this.m_createdByConnection = false;
    }

    protected JDBCBlob() {
        this.m_data = new byte[0];
        this.m_createdByConnection = true;
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected byte[] data() throws SQLException {
        return this.getData();
    }

    private synchronized byte[] getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(byte[] byArray) throws SQLException {
        this.checkClosed();
        this.m_data = byArray;
    }
}

