/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.SessionInterface;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCResultSet;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.types.BlobDataID;
import org.evosuite.shaded.org.hsqldb.types.BlobInputStream;

public class JDBCBlobClient
implements Blob {
    BlobDataID originalBlob;
    BlobDataID blob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized long length() throws SQLException {
        try {
            return this.blob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized byte[] getBytes(long l, int n) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, n)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this.session, this.blob, 0L, this.length());
    }

    @Override
    public synchronized long position(byte[] byArray, long l) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            long l2 = this.blob.position(this.session, byArray, l - 1L);
            if (l2 >= 0L) {
                ++l2;
            }
            return l2;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(Blob blob, long l) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (blob instanceof JDBCBlobClient) {
            BlobDataID blobDataID = ((JDBCBlobClient)blob).blob;
            try {
                long l2 = this.blob.position(this.session, blobDataID, l - 1L);
                if (l2 >= 0L) {
                    ++l2;
                }
                return l2;
            }
            catch (HsqlException hsqlException) {
                throw JDBCUtil.sqlException(hsqlException);
            }
        }
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, blob.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l);
    }

    @Override
    public synchronized int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public synchronized int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (!JDBCBlobClient.isInLimits(byArray.length, n, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        try {
            this.blob.setBytes(this.session, l - 1L, byArray, n, n2);
            return n2;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized OutputStream setBinaryStream(long l) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void truncate(long l) throws SQLException {
        try {
            this.blob.truncate(this.session, l);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public synchronized InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l - 1L, l2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new BlobInputStream(this.session, this.blob, l - 1L, l2);
    }

    public JDBCBlobClient(SessionInterface sessionInterface, BlobDataID blobDataID) {
        this.session = sessionInterface;
        this.blob = blobDataID;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public BlobDataID getBlob() {
        return this.blob;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n;
    }

    public synchronized void clearUpdates() {
        if (this.originalBlob != null) {
            this.blob = this.originalBlob;
            this.originalBlob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalBlob != null) {
            return;
        }
        this.originalBlob = this.blob;
        this.blob = (BlobDataID)this.blob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.blob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = Boolean.TRUE;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l2 >= 0L && l3 >= 0L && l2 + l3 <= l;
    }
}

