/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.evosuite.shaded.org.hsqldb.ClientConnection;
import org.evosuite.shaded.org.hsqldb.ClientConnectionHTTP;
import org.evosuite.shaded.org.hsqldb.DatabaseManager;
import org.evosuite.shaded.org.hsqldb.DatabaseURL;
import org.evosuite.shaded.org.hsqldb.HsqlDateTime;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.SessionInterface;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCArray;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCBlob;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCCallableStatement;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCClob;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCNClob;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCPreparedStatement;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCSQLXML;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCSavepoint;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCStatement;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.lib.StringUtil;
import org.evosuite.shaded.org.hsqldb.persist.HsqlProperties;
import org.evosuite.shaded.org.hsqldb.result.ResultProperties;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    HsqlProperties connProperties;
    HsqlProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;
    boolean isCloseResultSet;
    boolean isUseColumnName = true;

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int n = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement jDBCStatement = new JDBCStatement(this, n);
        return jDBCStatement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement jDBCCallableStatement = new JDBCCallableStatement(this, string, 1003, 1007, this.rsHoldability);
            return jDBCCallableStatement;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.length() == 0 || string.indexOf(123) == -1) {
            return string;
        }
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = null;
        int n4 = 0;
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.length());
                    }
                    stringBuffer.append(string.substring(n4, i));
                    n4 = i = this.onStartEscapeSequence(string, stringBuffer, i);
                    bl = true;
                    ++n3;
                    n = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --n;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    n -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        n = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        stringBuffer.append(string.substring(n4, i));
                        stringBuffer.append(' ');
                        n4 = ++i;
                        bl = true;
                        n = --n3 == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    stringBuffer.append(string.substring(n4, i));
                    n4 = i = this.onStartEscapeSequence(string, stringBuffer, i);
                    bl = true;
                    ++n3;
                    n = 3;
                }
            }
        }
        if (!bl) {
            return string;
        }
        stringBuffer.append(string.substring(n4, string.length()));
        return stringBuffer.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(bl);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, string);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        int n3 = ResultProperties.getValueForJDBC(n, n2, this.rsHoldability);
        return new JDBCStatement(this, n3);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n, n2, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n, n2, this.rsHoldability);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setHoldability(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        this.rsHoldability = n;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        JDBCSavepoint jDBCSavepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(jDBCSavepoint.name);
        }
        catch (HsqlException hsqlException) {
            JDBCUtil.throwError(hsqlException);
        }
        return jDBCSavepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string.startsWith("SYSTEM_SAVEPOINT_")) {
            throw JDBCUtil.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(string);
        }
        catch (HsqlException hsqlException) {
            JDBCUtil.throwError(hsqlException);
        }
        return new JDBCSavepoint(string, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String string = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            String string = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this != jDBCSavepoint.connection) {
            String string = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String string = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            String string = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this != jDBCSavepoint.connection) {
            String string = Error.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        int n4 = ResultProperties.getValueForJDBC(n, n2, n3);
        return new JDBCStatement(this, n4);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n, n2, n3, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n, n2, n3);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkClosed();
        try {
            if (n != 1 && n != 2) {
                throw JDBCUtil.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, n, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 21, nArray, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 11, null, stringArray);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument("timeout: " + n);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{true};
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Throwable throwable) {
                    blArray[0] = false;
                }
            }
        };
        if (n > 60) {
            n = 60;
        }
        n *= 1000;
        try {
            thread.start();
            long l = System.currentTimeMillis();
            thread.join(n);
            try {
                thread.setContextClassLoader(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n == 0) {
                return blArray[0];
            }
            return blArray[0] && System.currentTimeMillis() - l < (long)n;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        sQLClientInfoException.initCause(JDBCUtil.notSupported());
        throw sQLClientInfoException;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.isClosed && (properties == null || properties.isEmpty())) {
            return;
        }
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        if (this.isClosed) {
            sQLClientInfoException.initCause(JDBCUtil.connectionClosedException());
        } else {
            sQLClientInfoException.initCause(JDBCUtil.notSupported());
        }
        throw sQLClientInfoException;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        int n = Type.getTypeNr(string = string.toUpperCase());
        if (n < 0) {
            throw JDBCUtil.invalidArgument(string);
        }
        Type type = Type.getDefaultType(n);
        if (type.isArrayType() || type.isLobType() || type.isRowType()) {
            throw JDBCUtil.invalidArgument(string);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = type.convertJavaToSQL(this.sessionProxy, objectArray[i]);
                objectArray2[i] = type.convertToTypeLimits(this.sessionProxy, object);
            }
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        return new JDBCArray(objectArray2, type, this);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkClosed();
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkClosed();
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            JDBCUtil.nullArgument("schema");
        } else if (string.length() == 0) {
            JDBCUtil.invalidArgument("Zero-length schema");
        } else {
            new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(string);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw JDBCUtil.nullArgument("executor");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public JDBCConnection(HsqlProperties hsqlProperties) throws SQLException {
        String string = hsqlProperties.getProperty("user");
        String string2 = hsqlProperties.getProperty("password");
        String string3 = hsqlProperties.getProperty("connection_type");
        String string4 = hsqlProperties.getProperty("host");
        int n = hsqlProperties.getIntegerProperty("port", 0);
        String string5 = hsqlProperties.getProperty("path");
        String string6 = hsqlProperties.getProperty("database");
        boolean bl = string3 == "hsqls://" || string3 == "https://";
        boolean bl2 = hsqlProperties.isPropertyTrue("tls_wrapper", false);
        bl2 &= bl;
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        Calendar calendar = Calendar.getInstance();
        int n2 = HsqlDateTime.getZoneSeconds(calendar);
        try {
            if (DatabaseURL.isInProcessDatabaseType(string3)) {
                this.sessionProxy = DatabaseManager.newSession(string3, string6, string, string2, hsqlProperties, null, n2);
            } else if (string3 == "hsql://" || string3 == "hsqls://") {
                this.sessionProxy = new ClientConnection(string4, n, string5, string6, bl, bl2, string, string2, n2);
                this.isNetConn = true;
            } else if (string3 == "http://" || string3 == "https://") {
                this.sessionProxy = new ClientConnectionHTTP(string4, n, string5, string6, bl, bl2, string, string2, n2);
                this.isNetConn = true;
            } else {
                throw JDBCUtil.invalidArgument(string3);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = hsqlProperties;
            this.clientProperties = this.sessionProxy.getClientProperties();
            this.isCloseResultSet = this.connProperties.isPropertyTrue("close_result", false);
            this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public JDBCConnection(SessionInterface sessionInterface) {
        this.isInternal = true;
        this.sessionProxy = sessionInterface;
    }

    public JDBCConnection(JDBCConnection jDBCConnection, JDBCConnectionEventListener jDBCConnectionEventListener) {
        this.sessionProxy = jDBCConnection.sessionProxy;
        this.connProperties = jDBCConnection.connProperties;
        this.clientProperties = jDBCConnection.clientProperties;
        this.isPooled = true;
        this.poolEventListener = jDBCConnectionEventListener;
        if (this.connProperties != null) {
            this.isCloseResultSet = this.connProperties.isPropertyTrue("close_result", false);
            this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = sQLWarning;
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(1305, hsqlException.getMessage(), hsqlException);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String string, StringBuffer stringBuffer, int n) throws SQLException {
        stringBuffer.append(' ');
        ++n;
        n = StringUtil.skipSpaces(string, n);
        if (string.regionMatches(true, n, "fn ", 0, 3) || string.regionMatches(true, n, "oj ", 0, 3)) {
            n += 2;
        } else if (string.regionMatches(true, n, "ts ", 0, 3)) {
            stringBuffer.append("TIMESTAMP");
            n += 2;
        } else if (string.regionMatches(true, n, "d ", 0, 2)) {
            stringBuffer.append("DATE");
            ++n;
        } else if (string.regionMatches(true, n, "t ", 0, 2)) {
            stringBuffer.append("TIME");
            ++n;
        } else if (string.regionMatches(true, n, "call ", 0, 5)) {
            stringBuffer.append("CALL");
            n += 4;
        } else if (string.regionMatches(true, n, "?= call ", 0, 8)) {
            stringBuffer.append("CALL");
            n += 7;
        } else if (string.regionMatches(true, n, "? = call ", 0, 8)) {
            stringBuffer.append("CALL");
            n += 8;
        } else if (string.regionMatches(true, n, "escape ", 0, 7)) {
            n += 6;
        } else {
            throw JDBCUtil.sqlException(Error.error(425, string.substring(--n)));
        }
        return n;
    }
}

