/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCConnection;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.result.ResultMetaData;
import org.evosuite.shaded.org.hsqldb.types.DateTimeType;
import org.evosuite.shaded.org.hsqldb.types.IntervalType;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class JDBCParameterMetaData
implements ParameterMetaData,
Wrapper {
    ResultMetaData rmd;
    String[] classNames;
    int parameterCount;
    private boolean translateTTIType;

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkRange(n);
        return 2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.isNumberType();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        if (type.isDateTimeType()) {
            return type.displaySize();
        }
        long l = type.precision;
        if (l > Integer.MAX_VALUE) {
            l = 0L;
        }
        return (int)l;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.scale;
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getJDBCTypeCode();
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getNameString();
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.checkRange(n);
        Type type = this.translateType(this.rmd.columnTypes[--n]);
        return type.getJDBCClassName();
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.checkRange(n);
        return this.rmd.paramModes[--n];
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCParameterMetaData(JDBCConnection jDBCConnection, ResultMetaData resultMetaData) throws SQLException {
        this.rmd = resultMetaData;
        this.parameterCount = this.rmd.getColumnCount();
        if (jDBCConnection.clientProperties != null) {
            this.translateTTIType = jDBCConnection.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    private Type translateType(Type type) {
        if (this.translateTTIType) {
            if (type.isIntervalType()) {
                type = ((IntervalType)type).getCharacterType();
            } else if (type.isDateTimeTypeWithZone()) {
                type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
            }
        }
        return type;
    }

    void checkRange(int n) throws SQLException {
        if (n < 1 || n > this.parameterCount) {
            String string = n + " is out of range";
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n = this.getParameterCount();
        if (n == 0) {
            stringBuffer.append("[parameterCount=0]");
            return stringBuffer.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuffer.append('[');
        int n2 = methodArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("    parameter_");
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            stringBuffer.append('[');
            for (int j = 0; j < n2; ++j) {
                Method method = methodArray[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuffer.append(method.getName());
                stringBuffer.append('=');
                stringBuffer.append(method.invoke((Object)this, new Integer(i + 1)));
                if (j + 1 >= n2) continue;
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            if (i + 1 >= n) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

