/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCCommonDataSource;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.jdbc.pool.JDBCPooledConnection;
import org.evosuite.shaded.org.hsqldb.jdbc.pool.JDBCPooledDataSource;

public class JDBCPool
extends JDBCCommonDataSource
implements DataSource,
Serializable,
Referenceable,
ConnectionEventListener,
StatementEventListener,
Wrapper {
    AtomicIntegerArray states;
    JDBCPooledConnection[] connections;
    JDBCPooledDataSource source = new JDBCPooledDataSource();
    volatile boolean closed;

    @Override
    public Connection getConnection() throws SQLException {
        int n = 300;
        if (this.source.loginTimeout != 0) {
            n = this.source.loginTimeout * 10;
        }
        if (this.closed) {
            throw new SQLException("connection pool is closed");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.states.length(); ++j) {
                if (this.states.compareAndSet(j, 1, 2)) {
                    return this.connections[j].getConnection();
                }
                if (!this.states.compareAndSet(j, 0, 2)) continue;
                try {
                    JDBCPooledConnection jDBCPooledConnection = (JDBCPooledConnection)this.source.getPooledConnection();
                    jDBCPooledConnection.addConnectionEventListener(this);
                    jDBCPooledConnection.addStatementEventListener(this);
                    this.connections[j] = jDBCPooledConnection;
                    return this.connections[j].getConnection();
                }
                catch (SQLException sQLException) {
                    this.states.set(j, 0);
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.source.getPooledConnection(string, string2).getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = "org.evosuite.shaded.org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.source.getDatabase()));
        reference.add(new StringRefAddr("user", this.source.getUser()));
        reference.add(new StringRefAddr("password", this.source.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.source.loginTimeout)));
        reference.add(new StringRefAddr("poolSize", Integer.toString(this.connections.length)));
        return reference;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] != pooledConnection) continue;
            this.states.set(i, 1);
            break;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] != pooledConnection) continue;
            this.states.set(i, 2);
            this.connections[i] = null;
            this.states.set(i, 0);
            break;
        }
    }

    @Override
    public void statementClosed(StatementEvent statementEvent) {
    }

    @Override
    public void statementErrorOccurred(StatementEvent statementEvent) {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.source.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.source.setLoginTimeout(n);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.source.getLoginTimeout();
    }

    @Override
    public String getDescription() {
        return "org.evosuite.shaded.org.hsqldb.jdbc.JDBCPool max size " + this.connections.length;
    }

    @Override
    public String getDataSourceName() {
        return "org.evosuite.shaded.org.hsqldb.jdbc.JDBCPool";
    }

    @Override
    public String getDatabaseName() {
        return this.source.getUrl();
    }

    @Override
    public String getDatabase() {
        return this.source.getDatabase();
    }

    @Override
    public String getUrl() {
        return this.source.getUrl();
    }

    @Override
    public String getUser() {
        return this.source.getUser();
    }

    @Override
    public void setDatabaseName(String string) {
        this.source.setDatabaseName(string);
    }

    @Override
    public void setDatabase(String string) {
        this.source.setDatabase(string);
    }

    @Override
    public void setUrl(String string) {
        this.source.setUrl(string);
    }

    @Override
    public void setPassword(String string) {
        this.source.setPassword(string);
    }

    @Override
    public void setUser(String string) {
        this.source.setUser(string);
    }

    @Override
    public void setProperties(Properties properties) {
        this.source.setProperties(properties);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    public JDBCPool() {
        this(10);
    }

    public JDBCPool(int n) {
        this.connections = new JDBCPooledConnection[n];
        this.states = new AtomicIntegerArray(n);
    }

    public void close(int n) throws SQLException {
        int n2;
        if (n < 0 || n > 60) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Thread.sleep(1000 * n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (n2 = 0; n2 < this.connections.length; ++n2) {
            if (this.connections[n2] == null) continue;
            this.connections[n2].release();
        }
        for (n2 = 0; n2 < this.connections.length; ++n2) {
            this.connections[n2] = null;
        }
    }

    static interface RefState {
        public static final int empty = 0;
        public static final int available = 1;
        public static final int allocated = 2;
    }
}

