/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.io.IOException;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.Arrays;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.lib.StringConverter;

public final class JDBCRowId
implements RowId {
    private int hash;
    private final byte[] id;

    public JDBCRowId(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw JDBCUtil.nullArgument("id");
        }
        this.id = byArray;
    }

    public JDBCRowId(RowId rowId) throws SQLException {
        this(rowId.getBytes());
    }

    public JDBCRowId(String string) throws SQLException {
        if (string == null) {
            throw JDBCUtil.nullArgument("hex");
        }
        try {
            this.id = StringConverter.hexStringToByteArray(string);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(423, "hex: " + iOException);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JDBCRowId && Arrays.equals(this.id, ((JDBCRowId)object).id);
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.id.clone();
    }

    @Override
    public String toString() {
        return StringConverter.byteArrayToHexString(this.id);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.id);
        }
        return this.hash;
    }

    Object id() {
        return this.id;
    }
}

