/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCConnection;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCResultSet;
import org.evosuite.shaded.org.hsqldb.jdbc.JDBCUtil;
import org.evosuite.shaded.org.hsqldb.result.Result;

class JDBCStatementBase {
    volatile boolean isClosed;
    protected boolean isEscapeProcessing = true;
    protected JDBCConnection connection;
    protected int maxRows;
    protected int fetchSize = 0;
    protected int fetchDirection = 1000;
    protected Result resultIn;
    protected Result errorResult;
    protected Result generatedResult;
    protected int rsProperties;
    protected Result resultOut;
    protected Result batchResultOut;
    protected JDBCResultSet currentResultSet;
    protected JDBCResultSet generatedResultSet;
    protected SQLWarning rootWarning;
    protected int resultSetCounter;
    protected int queryTimeout;
    int connectionIncarnation;
    static final int CLOSE_CURRENT_RESULT = 1;
    static final int KEEP_CURRENT_RESULT = 2;
    static final int CLOSE_ALL_RESULTS = 3;
    static final int SUCCESS_NO_INFO = -2;
    static final int EXECUTE_FAILED = -3;
    static final int RETURN_GENERATED_KEYS = 1;
    static final int NO_GENERATED_KEYS = 2;

    JDBCStatementBase() {
    }

    public synchronized void close() throws SQLException {
    }

    void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1251);
        }
        if (this.connection.isClosed) {
            this.close();
            throw JDBCUtil.sqlException(1353);
        }
        if (this.connectionIncarnation != this.connection.incarnation) {
            throw JDBCUtil.sqlException(1353);
        }
    }

    void performPostExecute() throws SQLException {
        this.resultOut.clearLobResults();
        this.generatedResult = null;
        if (this.resultIn == null) {
            return;
        }
        this.rootWarning = null;
        Result result = this.resultIn;
        while (result.getChainedResult() != null) {
            if ((result = result.getUnlinkChainedResult()).getType() == 19) {
                SQLWarning sQLWarning = JDBCUtil.sqlWarning(result);
                if (this.rootWarning == null) {
                    this.rootWarning = sQLWarning;
                    continue;
                }
                this.rootWarning.setNextWarning(sQLWarning);
                continue;
            }
            if (result.getType() == 2) {
                this.errorResult = result;
                continue;
            }
            if (result.getType() == 20) {
                this.generatedResult = result;
                continue;
            }
            if (result.getType() != 3) continue;
            this.resultIn.addChainedResult(result);
        }
        if (this.rootWarning != null) {
            this.connection.setWarnings(this.rootWarning);
        }
    }

    int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.resultIn == null || this.resultIn.isData() ? -1 : this.resultIn.getUpdateCount();
    }

    ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        JDBCResultSet jDBCResultSet = this.currentResultSet;
        if (!this.connection.isCloseResultSet) {
            this.currentResultSet = null;
        }
        if (jDBCResultSet == null && this.resultOut.getStatementType() == 2) {
            return JDBCResultSet.newEptyResultSet();
        }
        return jDBCResultSet;
    }

    boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    boolean getMoreResults(int n) throws SQLException {
        this.checkClosed();
        if (this.resultIn == null) {
            return false;
        }
        this.resultIn = this.resultIn.getChainedResult();
        if (this.currentResultSet != null && n != 2) {
            this.currentResultSet.close();
        }
        this.currentResultSet = null;
        if (this.resultIn != null) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
            return true;
        }
        return false;
    }

    ResultSet getGeneratedResultSet() throws SQLException {
        if (this.generatedResultSet != null) {
            this.generatedResultSet.close();
        }
        if (this.generatedResult == null) {
            this.generatedResult = Result.emptyGeneratedResult;
        }
        this.generatedResultSet = new JDBCResultSet(this.connection, null, this.generatedResult, this.generatedResult.metaData);
        return this.generatedResultSet;
    }

    void closeResultData() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        if (this.generatedResultSet != null) {
            this.generatedResultSet.close();
        }
        this.generatedResultSet = null;
        this.generatedResult = null;
        this.resultIn = null;
        this.currentResultSet = null;
    }

    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
    }

    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return false;
    }
}

