/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.navigator;

import java.io.IOException;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.lib.OrderedLongKeyHashMap;
import org.evosuite.shaded.org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.evosuite.shaded.org.hsqldb.result.ResultMetaData;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputInterface;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputInterface;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class RowSetNavigatorDataChangeMemory
implements RowSetNavigatorDataChange {
    public static RowSetNavigatorDataChangeMemory emptyRowSet = new RowSetNavigatorDataChangeMemory(null);
    int size;
    int currentPos = -1;
    OrderedLongKeyHashMap list;
    Session session;

    public RowSetNavigatorDataChangeMemory(Session session) {
        this.session = session;
        this.list = new OrderedLongKeyHashMap(64, true);
    }

    @Override
    public void release() {
        this.beforeFirst();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getRowPosition() {
        return this.currentPos;
    }

    @Override
    public boolean next() {
        if (this.currentPos < this.size - 1) {
            ++this.currentPos;
            return true;
        }
        this.currentPos = this.size - 1;
        return false;
    }

    @Override
    public boolean beforeFirst() {
        this.currentPos = -1;
        return true;
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.list.getValueByIndex(this.currentPos);
    }

    @Override
    public Object[] getCurrentChangedData() {
        return (Object[])this.list.getSecondValueByIndex(this.currentPos);
    }

    @Override
    public int[] getCurrentChangedColumns() {
        return (int[])this.list.getThirdValueByIndex(this.currentPos);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
    }

    @Override
    public void endMainDataSet() {
    }

    @Override
    public boolean addRow(Row row) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            this.list.put(row.getId(), row, null);
            ++this.size;
            return true;
        }
        if (this.list.getSecondValueByIndex(n) != null) {
            if (this.session.database.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            this.list.setSecondValueByIndex(n, null);
            this.list.setThirdValueByIndex(n, null);
            return true;
        }
        return false;
    }

    @Override
    public Object[] addRow(Session session, Row row, Object[] objectArray, Type[] typeArray, int[] nArray) {
        long l = row.getId();
        int n = this.list.getLookup(l);
        if (n == -1) {
            this.list.put(l, row, objectArray);
            this.list.setThirdValueByIndex(this.size, nArray);
            ++this.size;
            return objectArray;
        }
        Object[] objectArray2 = ((Row)this.list.getFirstByLookup(n)).getData();
        Object[] objectArray3 = (Object[])this.list.getSecondValueByIndex(n);
        if (objectArray3 == null) {
            if (session.database.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (typeArray[n2].compare(session, objectArray[n2], objectArray3[n2]) == 0) continue;
            if (typeArray[n2].compare(session, objectArray2[n2], objectArray3[n2]) != 0) {
                if (!session.database.sqlEnforceTDCU) continue;
                throw Error.error(3900);
            }
            objectArray3[n2] = objectArray[n2];
        }
        int[] nArray2 = (int[])this.list.getThirdValueByIndex(n);
        nArray2 = ArrayUtil.union(nArray2, nArray);
        this.list.setThirdValueByIndex(n, nArray2);
        return objectArray3;
    }

    @Override
    public boolean containsDeletedRow(Row row) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            return false;
        }
        Object[] objectArray = (Object[])this.list.getSecondValueByIndex(n);
        return objectArray == null;
    }
}

