/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArraySort;
import org.evosuite.shaded.org.hsqldb.lib.Iterator;
import org.evosuite.shaded.org.hsqldb.lib.ObjectComparator;
import org.evosuite.shaded.org.hsqldb.lib.StopWatch;
import org.evosuite.shaded.org.hsqldb.map.BaseHashMap;
import org.evosuite.shaded.org.hsqldb.persist.CachedObject;
import org.evosuite.shaded.org.hsqldb.persist.DataFileCache;

public class Cache
extends BaseHashMap {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private final BaseHashMap.BaseHashIterator objectIterator;
    private boolean updateAccess;
    private long maxPositionOnCleanup;
    private CachedObject[] rowTable;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dataFileCache) {
        super(dataFileCache.capacity(), 3, 0, true);
        this.maxCapacity = dataFileCache.capacity();
        this.dataFileCache = dataFileCache;
        this.capacity = dataFileCache.capacity();
        this.bytesCapacity = dataFileCache.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
        this.objectIterator = new BaseHashMap.BaseHashIterator(true);
        this.updateAccess = true;
        this.comparator = this.rowComparator;
    }

    void resize(int n, long l) {
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public CachedObject get(long l) {
        int n;
        if (this.accessCount > 0x7FEFFFFF && this.updateAccess) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        if ((n = this.getObjectLookup(l)) == -1) {
            return null;
        }
        this.accessTable[n] = ++this.accessCount;
        CachedObject cachedObject = (CachedObject)this.objectKeyTable[n];
        return cachedObject;
    }

    void put(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        if (this.size() >= this.capacity || (long)n + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp(false);
            if (this.size() >= this.capacity) {
                this.clearUnchanged();
            }
            if (this.size() >= this.capacity) {
                this.cleanUp(true);
            }
            if (this.size() >= this.capacity) {
                throw Error.error(471, String.valueOf(this.capacity));
            }
        }
        if (this.accessCount > 0x7FEFFFFF && this.updateAccess) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        super.addOrRemoveObject(cachedObject, cachedObject.getPos(), false);
        cachedObject.setInMemory(true);
        this.cacheBytesLength += (long)n;
    }

    CachedObject release(long l) {
        CachedObject cachedObject = (CachedObject)super.addOrRemoveObject(null, l, true);
        if (cachedObject == null) {
            return null;
        }
        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        cachedObject.setInMemory(false);
        return cachedObject;
    }

    void replace(long l, CachedObject cachedObject) {
        int n = super.getLookup(l);
        this.objectKeyTable[n] = cachedObject;
    }

    private void updateAccessCounts() {
        for (int i = 0; i < this.objectKeyTable.length; ++i) {
            int n;
            CachedObject cachedObject = (CachedObject)this.objectKeyTable[i];
            if (cachedObject == null || (n = cachedObject.getAccessCount()) <= this.accessTable[i]) continue;
            this.accessTable[i] = n;
        }
    }

    private void updateObjectAccessCounts() {
        for (int i = 0; i < this.objectKeyTable.length; ++i) {
            CachedObject cachedObject = (CachedObject)this.objectKeyTable[i];
            if (cachedObject == null) continue;
            int n = this.accessTable[i];
            cachedObject.updateAccessCount(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(boolean bl) {
        if (this.updateAccess) {
            this.updateAccessCounts();
        }
        int n = this.size() / 2;
        int n2 = this.getAccessCountCeiling(n, n / 8);
        int n3 = 0;
        if (bl) {
            n2 = this.accessCount + 1;
        }
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            boolean bl2;
            CachedObject cachedObject = (CachedObject)this.objectIterator.next();
            int n4 = this.objectIterator.getAccessCount();
            boolean bl3 = n4 < n2;
            boolean bl4 = bl2 = cachedObject.isNew() && cachedObject.getStorageSize() >= 4096;
            if (!bl3 && !bl2) continue;
            this.objectIterator.setAccessCount(n2);
            CachedObject cachedObject2 = cachedObject;
            synchronized (cachedObject2) {
                if (cachedObject.isKeepInMemory()) {
                    continue;
                }
                if (cachedObject.hasChanged()) {
                    this.rowTable[n3++] = cachedObject;
                }
                if (bl3) {
                    cachedObject.setInMemory(false);
                    this.objectIterator.remove();
                    this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                }
            }
            if (n3 != this.rowTable.length) continue;
            this.saveRows(n3);
            n3 = 0;
        }
        super.setAccessCountFloor(n2);
        this.saveRows(n3);
        this.maxPositionOnCleanup = this.dataFileCache.fileFreePosition / (long)this.dataFileCache.dataFileScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnchanged() {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            CachedObject cachedObject2 = cachedObject = (CachedObject)this.objectIterator.next();
            synchronized (cachedObject2) {
                if (!cachedObject.isKeepInMemory() && !cachedObject.hasChanged()) {
                    cachedObject.setInMemory(false);
                    this.objectIterator.remove();
                    this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                }
            }
        }
    }

    private synchronized void saveRows(int n) {
        if (n == 0) {
            return;
        }
        long l = this.saveAllTimer.elapsedTime();
        this.rowComparator.setType(1);
        this.sortTimer.zero();
        this.sortTimer.start();
        ArraySort.sort(this.rowTable, 0, n, this.rowComparator);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, n);
        this.saveRowCount += n;
        this.saveAllTimer.stop();
        this.logSaveRowsEvent(n, l);
    }

    void saveAll() {
        int n = 0;
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            if (n == this.rowTable.length) {
                this.saveRows(n);
                n = 0;
            }
            if (!(cachedObject = (CachedObject)this.objectIterator.next()).hasChanged()) continue;
            this.rowTable[n] = cachedObject;
            ++n;
        }
        this.saveRows(n);
    }

    void logSaveRowsEvent(int n, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cache save rows [count,time] totals ");
        stringBuffer.append(this.saveRowCount);
        stringBuffer.append(',').append(this.saveAllTimer.elapsedTime()).append(' ');
        stringBuffer.append("operation ").append(n).append(',');
        stringBuffer.append(this.saveAllTimer.elapsedTime() - l).append(' ');
        stringBuffer.append("txts ");
        stringBuffer.append(this.dataFileCache.database.txManager.getGlobalChangeTimestamp());
        this.dataFileCache.logDetailEvent(stringBuffer.toString());
    }

    @Override
    public void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    public Iterator getIterator() {
        this.objectIterator.reset();
        return this.objectIterator;
    }

    static final class CachedObjectComparator
    implements ObjectComparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType = 1;

        CachedObjectComparator() {
        }

        void setType(int n) {
            this.compareType = n;
        }

        public int compare(Object object, Object object2) {
            long l;
            switch (this.compareType) {
                case 1: {
                    l = ((CachedObject)object).getPos() - ((CachedObject)object2).getPos();
                    break;
                }
                case 2: {
                    l = ((CachedObject)object).getStorageSize() - ((CachedObject)object2).getStorageSize();
                    break;
                }
                default: {
                    return 0;
                }
            }
            return l == 0L ? 0 : (l > 0L ? 1 : -1);
        }

        @Override
        public int hashCode(Object object) {
            return object.hashCode();
        }

        @Override
        public long longKey(Object object) {
            return ((CachedObject)object).getPos();
        }
    }
}

