/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import java.io.IOException;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.LongLookup;
import org.evosuite.shaded.org.hsqldb.persist.CachedObject;
import org.evosuite.shaded.org.hsqldb.persist.CachedObjectBase;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputInterface;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputInterface;

public class DirectoryBlockCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 12;
    int[] tableIds;
    int[] bitmapAddress;
    char[] freeSpace;
    char[] freeSpaceBlock;

    public DirectoryBlockCachedObject(int n) {
        this.tableIds = new int[n];
        this.bitmapAddress = new int[n];
        this.freeSpace = new char[n];
        this.freeSpaceBlock = new char[n];
        this.hasChanged = true;
    }

    public CachedObject newInstance(int n) {
        return new DirectoryBlockCachedObject(n);
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        this.position = rowInputInterface.getPos();
        int n = this.tableIds.length;
        try {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.tableIds[n2] = rowInputInterface.readInt();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.bitmapAddress[n2] = rowInputInterface.readInt();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.freeSpace[n2] = rowInputInterface.readChar();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.freeSpaceBlock[n2] = rowInputInterface.readChar();
            }
        }
        catch (IOException iOException) {
            throw Error.error(467, iOException);
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.tableIds.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.tableIds.length * 12;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        int n;
        int n2 = this.tableIds.length;
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(this.tableIds[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(this.bitmapAddress[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeChar(this.freeSpace[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeChar(this.freeSpaceBlock[n]);
        }
        rowOutputInterface.writeEnd();
        this.hasChanged = false;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        this.write(rowOutputInterface);
    }

    public int[] getTableIdArray() {
        return this.tableIds;
    }

    public int[] getBitmapAddressArray() {
        return this.bitmapAddress;
    }

    public char[] getFreeSpaceArray() {
        return this.freeSpace;
    }

    public char[] getFreeBlockArray() {
        return this.freeSpaceBlock;
    }
}

