/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import java.io.IOException;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.LongLookup;
import org.evosuite.shaded.org.hsqldb.persist.CachedObject;
import org.evosuite.shaded.org.hsqldb.persist.CachedObjectBase;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputInterface;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputInterface;

public class IntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    int[] values;

    public IntArrayCachedObject(int n) {
        this.values = new int[n];
        this.hasChanged = true;
    }

    public CachedObject newInstance(int n) {
        return new IntArrayCachedObject(n);
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        this.position = rowInputInterface.getPos();
        int n = this.values.length;
        try {
            for (int i = 0; i < n; ++i) {
                this.values[i] = rowInputInterface.readInt();
            }
        }
        catch (IOException iOException) {
            throw Error.error(467, iOException);
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.values.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.values.length * 4;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            rowOutputInterface.writeInt(this.values[i]);
        }
        rowOutputInterface.writeEnd();
        this.hasChanged = false;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        this.write(rowOutputInterface);
    }

    public int[] getIntArray() {
        return this.values;
    }
}

