/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.NumberSequence;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.FileAccess;
import org.evosuite.shaded.org.hsqldb.persist.Crypto;
import org.evosuite.shaded.org.hsqldb.persist.DataFileCache;
import org.evosuite.shaded.org.hsqldb.persist.DataFileDefrag;
import org.evosuite.shaded.org.hsqldb.persist.HsqlDatabaseProperties;
import org.evosuite.shaded.org.hsqldb.persist.ScriptRunner;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderBase;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderDecode;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderText;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptWriterBase;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptWriterEncode;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptWriterText;

public class Log {
    private HsqlDatabaseProperties properties;
    private String fileName;
    private Database database;
    private FileAccess fa;
    ScriptWriterBase dbLogWriter;
    private String scriptFileName;
    private String logFileName;
    private boolean filesReadOnly;
    private long maxLogSize;
    private int writeDelay;
    private DataFileCache cache;
    private boolean isModified;

    Log(Database database) {
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.fileName = database.getPath();
        this.properties = database.getProperties();
    }

    void initParams() {
        this.maxLogSize = (long)this.database.logger.propLogSize * 1024L * 1024L;
        this.writeDelay = this.database.logger.propWriteDelay;
        this.filesReadOnly = this.database.isFilesReadOnly();
        this.scriptFileName = this.fileName + ".script";
    }

    void setupLogFile() {
        if (this.logFileName == null) {
            this.logFileName = this.fileName + ".log";
        }
    }

    void open() {
        this.initParams();
        int n = this.properties.getDBModified();
        switch (n) {
            case 3: {
                break;
            }
            case 1: {
                this.database.logger.logInfoEvent("open start - state modified");
                this.deleteNewAndOldFiles();
                this.deleteOldTempFiles();
                if (this.properties.isVersion18()) {
                    if (this.fa.isStreamElement(this.scriptFileName)) {
                        this.processScript();
                    } else {
                        this.database.schemaManager.createPublicSchema();
                    }
                    HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
                    if (hsqlName != null) {
                        this.database.schemaManager.setDefaultSchemaHsqlName(hsqlName);
                    }
                } else {
                    this.processScript();
                }
                this.processLog();
                this.checkpoint();
                break;
            }
            case 2: {
                this.database.logger.logInfoEvent("open start - state new files");
                this.renameNewDataFile();
                this.renameNewScript();
                this.deleteLog();
                this.backupData();
                this.properties.setDBModified(0);
            }
            case 0: {
                this.database.logger.logInfoEvent("open start - state not modified");
                this.processScript();
                if (this.filesReadOnly || !this.isAnyCacheModified()) break;
                this.properties.setDBModified(1);
                this.checkpoint();
            }
        }
        if (!this.filesReadOnly) {
            this.openLog();
        }
    }

    void close(boolean bl) {
        this.closeLog();
        this.deleteOldDataFiles();
        this.deleteOldTempFiles();
        this.deleteTempFileDirectory();
        this.writeScript(bl);
        this.database.logger.closeAllTextCaches(bl);
        if (this.cache != null) {
            this.cache.close();
        }
        this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
        this.properties.setDBModified(2);
        this.deleteLog();
        boolean bl2 = true;
        if (this.cache != null) {
            if (bl) {
                this.cache.deleteFile();
                this.cache.deleteBackup();
                if (this.fa.isStreamElement(this.cache.dataFileName)) {
                    this.database.logger.logInfoEvent("delete .data file failed ");
                    bl2 = false;
                }
                if (this.fa.isStreamElement(this.cache.backupFileName)) {
                    this.database.logger.logInfoEvent("delete .backup file failed ");
                    bl2 = false;
                }
            } else {
                this.cache.backupDataFile(false);
            }
        }
        if (this.fa.isStreamElement(this.logFileName)) {
            this.database.logger.logInfoEvent("delete .log file failed ");
            bl2 = false;
        }
        this.renameNewScript();
        if (bl2) {
            this.properties.setDBModified(0);
        }
    }

    void shutdown() {
        if (this.cache != null) {
            this.cache.release();
        }
        this.database.logger.closeAllTextCaches(false);
        this.closeLog();
    }

    void deleteNewAndOldFiles() {
        this.deleteOldDataFiles();
        this.fa.removeElement(this.fileName + ".data" + ".new");
        this.fa.removeElement(this.fileName + ".backup" + ".new");
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteBackup() {
        this.fa.removeElement(this.fileName + ".backup");
    }

    void backupData() {
        DataFileCache.backupFile(this.database, this.fileName + ".data", this.fileName + ".backup", false);
    }

    void renameNewDataFile() {
        DataFileCache.renameDataFile(this.database, this.fileName + ".data");
    }

    void renameNewBackup() {
        DataFileCache.renameBackupFile(this.database, this.fileName + ".backup");
    }

    void renameNewScript() {
        if (this.fa.isStreamElement(this.scriptFileName + ".new")) {
            this.fa.removeElement(this.scriptFileName);
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
        }
    }

    boolean renameNewDataFileDone() {
        return this.fa.isStreamElement(this.fileName + ".data") && !this.fa.isStreamElement(this.fileName + ".data" + ".new");
    }

    boolean renameNewScriptDone() {
        return this.fa.isStreamElement(this.scriptFileName) && !this.fa.isStreamElement(this.scriptFileName + ".new");
    }

    void deleteNewScript() {
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteNewBackup() {
        this.fa.removeElement(this.fileName + ".backup" + ".new");
    }

    void deleteLog() {
        this.setupLogFile();
        this.fa.removeElement(this.logFileName);
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isModified()) {
            return true;
        }
        return this.database.logger.isAnyTextCacheModified();
    }

    void checkpoint() {
        if (this.filesReadOnly) {
            return;
        }
        boolean bl = this.checkpointClose();
        this.checkpointReopen();
        if (bl) {
            this.database.lobManager.deleteUnusedLobs();
        } else {
            this.database.logger.logSevereEvent("checkpoint failed - see previous error", null);
        }
    }

    void checkpoint(boolean bl) {
        if (this.filesReadOnly) {
            return;
        }
        if (this.cache == null) {
            bl = false;
        } else if (this.forceDefrag()) {
            bl = true;
        }
        if (bl) {
            this.defrag();
        } else {
            this.checkpoint();
        }
    }

    boolean checkpointClose() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.logger.logInfoEvent("checkpointClose start");
        this.synchLog();
        this.database.lobManager.synch();
        this.deleteOldDataFiles();
        try {
            this.writeScript(false);
            if (this.cache != null) {
                this.cache.reset();
                this.cache.backupDataFile(true);
            }
            this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
            this.properties.setDBModified(2);
        }
        catch (Throwable throwable) {
            this.deleteNewScript();
            this.deleteNewBackup();
            this.database.logger.logSevereEvent("checkpoint failed - recovered", throwable);
            return false;
        }
        this.closeLog();
        this.deleteLog();
        this.renameNewScript();
        this.renameNewBackup();
        try {
            this.properties.setDBModified(0);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("logger.checkpointClose properties file save failed", throwable);
        }
        this.database.logger.logInfoEvent("checkpointClose end");
        return true;
    }

    boolean checkpointReopen() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.sessionManager.resetLoggedSchemas();
        try {
            if (this.cache != null) {
                this.cache.reopen();
            }
            if (this.dbLogWriter != null) {
                this.openLog();
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void defrag() {
        this.database.logger.logInfoEvent("defrag start");
        try {
            this.synchLog();
            this.database.lobManager.synch();
            this.deleteOldDataFiles();
            DataFileDefrag dataFileDefrag = this.cache.defrag();
            this.database.persistentStoreCollection.setNewTableSpaces();
            this.database.sessionManager.resetLoggedSchemas();
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("defrag failure", throwable);
            throw Error.error(466, throwable);
        }
        this.database.logger.logInfoEvent("defrag end");
    }

    boolean forceDefrag() {
        long l = (long)this.database.logger.propCacheDefragLimit * this.cache.getFileFreePos() / 100L;
        if (l == 0L) {
            return false;
        }
        long l2 = this.cache.getLostBlockSize();
        return l2 > l;
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.database, this.fileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    void setLogSize(int n) {
        this.maxLogSize = (long)n * 1024L * 1024L;
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.dbLogWriter != null && this.dbLogWriter.getWriteDelay() != n) {
            this.dbLogWriter.forceSync();
            this.dbLogWriter.stop();
            this.dbLogWriter.setWriteDelay(n);
            this.dbLogWriter.start();
        }
    }

    public void setIncrementBackup(boolean bl) {
        if (this.cache != null) {
            this.cache.setIncrementBackup(bl);
        }
    }

    void writeOtherStatement(Session session, String string) {
        try {
            this.dbLogWriter.writeOtherStatement(session, string);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
        this.setModified();
    }

    void writeInsertStatement(Session session, Row row, Table table) {
        try {
            this.dbLogWriter.writeInsertStatement(session, row, table);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) {
        try {
            this.dbLogWriter.writeDeleteStatement(session, table, objectArray);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeSequenceStatement(Session session, NumberSequence numberSequence) {
        try {
            this.dbLogWriter.writeSequenceStatement(session, numberSequence);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
        this.setModified();
    }

    void writeCommitStatement(Session session) {
        try {
            this.dbLogWriter.writeCommitStatement(session);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
        this.setModified();
    }

    private void setModified() {
        if (!this.isModified) {
            this.database.databaseProperties.setDBModified(1);
            this.isModified = true;
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
        }
    }

    void openLog() {
        if (this.filesReadOnly) {
            return;
        }
        this.setupLogFile();
        this.deleteLog();
        Crypto crypto = this.database.logger.getCrypto();
        try {
            this.dbLogWriter = crypto == null ? new ScriptWriterText(this.database, this.logFileName, false, false, false) : new ScriptWriterEncode(this.database, this.logFileName, crypto);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.dbLogWriter.start();
            this.isModified = false;
        }
        catch (Throwable throwable) {
            throw Error.error(452, this.logFileName);
        }
    }

    synchronized void closeLog() {
        if (this.dbLogWriter != null) {
            this.database.logger.logDetailEvent("log close size: " + this.dbLogWriter.size());
            this.dbLogWriter.close();
        }
    }

    void writeScript(boolean bl) {
        ScriptWriterText scriptWriterText;
        this.deleteNewScript();
        Crypto crypto = this.database.logger.getCrypto();
        if (crypto == null) {
            boolean bl2 = this.database.logger.propScriptFormat == 3;
            scriptWriterText = new ScriptWriterText(this.database, this.scriptFileName + ".new", bl, bl2);
        } else {
            scriptWriterText = new ScriptWriterEncode(this.database, this.scriptFileName + ".new", bl, crypto);
        }
        scriptWriterText.writeAll();
        scriptWriterText.close();
        scriptWriterText = null;
    }

    private void processScript() {
        ScriptReaderBase scriptReaderBase = null;
        try {
            Crypto crypto = this.database.logger.getCrypto();
            if (crypto == null) {
                boolean bl = this.database.logger.propScriptFormat == 3;
                scriptReaderBase = new ScriptReaderText(this.database, this.scriptFileName, bl);
            } else {
                scriptReaderBase = new ScriptReaderDecode(this.database, this.scriptFileName, crypto, false);
            }
            Session session = this.database.sessionManager.getSysSessionForScript(this.database);
            scriptReaderBase.readAll(session);
            scriptReaderBase.close();
        }
        catch (Throwable throwable) {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
                if (this.cache != null) {
                    this.cache.release();
                }
                this.database.logger.closeAllTextCaches(false);
            }
            this.database.logger.logWarningEvent("Script processing failure", throwable);
            if (throwable instanceof HsqlException) {
                throw (HsqlException)throwable;
            }
            if (throwable instanceof IOException) {
                throw Error.error(452, throwable);
            }
            if (throwable instanceof OutOfMemoryError) {
                throw Error.error(460);
            }
            throw Error.error(458, throwable);
        }
    }

    private void processLog() {
        this.setupLogFile();
        if (this.fa.isStreamElement(this.logFileName)) {
            ScriptRunner.runScript(this.database, this.logFileName);
        }
    }

    void deleteOldDataFiles() {
        if (this.database.logger.isStoredFileAccess()) {
            return;
        }
        try {
            File file = new File(this.database.getCanonicalPath());
            File[] fileArray = file.getParentFile().listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().startsWith(file.getName()) || !fileArray[i].getName().endsWith(".old")) continue;
                fileArray[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteOldTempFiles() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteTempFileDirectory() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    String getLogFileName() {
        return this.logFileName;
    }
}

