/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TableBase;
import org.evosuite.shaded.org.hsqldb.lib.Iterator;
import org.evosuite.shaded.org.hsqldb.lib.LongKeyHashMap;
import org.evosuite.shaded.org.hsqldb.persist.DataFileCache;
import org.evosuite.shaded.org.hsqldb.persist.PersistentStore;
import org.evosuite.shaded.org.hsqldb.persist.PersistentStoreCollection;
import org.evosuite.shaded.org.hsqldb.persist.TableSpaceManager;

public class PersistentStoreCollectionDatabase
implements PersistentStoreCollection {
    private Database database;
    private long persistentStoreIdSequence;
    private final LongKeyHashMap rowStoreMap = new LongKeyHashMap();

    public PersistentStoreCollectionDatabase(Database database) {
        this.database = database;
    }

    @Override
    public void setStore(Object object, PersistentStore persistentStore) {
        long l = ((TableBase)object).getPersistenceId();
        if (persistentStore == null) {
            this.rowStoreMap.remove(l);
        } else {
            this.rowStoreMap.put(l, persistentStore);
        }
    }

    @Override
    public synchronized PersistentStore getStore(Object object) {
        long l = ((TableBase)object).getPersistenceId();
        PersistentStore persistentStore = (PersistentStore)this.rowStoreMap.get(l);
        if (persistentStore == null) {
            ((TableBase)object).store = persistentStore = this.database.logger.newStore(null, this, (TableBase)object);
        }
        return persistentStore;
    }

    @Override
    public void release() {
        if (this.rowStoreMap.isEmpty()) {
            return;
        }
        Iterator iterator = this.rowStoreMap.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            persistentStore.release();
        }
        this.rowStoreMap.clear();
    }

    public void removeStore(Table table) {
        PersistentStore persistentStore = (PersistentStore)this.rowStoreMap.get(table.getPersistenceId());
        if (persistentStore != null) {
            persistentStore.removeAll();
            persistentStore.release();
            this.rowStoreMap.remove(table.getPersistenceId());
        }
    }

    public long getNextId() {
        return this.persistentStoreIdSequence++;
    }

    public void setNewTableSpaces() {
        DataFileCache dataFileCache = this.database.logger.getCache();
        if (dataFileCache == null) {
            return;
        }
        Iterator iterator = this.rowStoreMap.values().iterator();
        while (iterator.hasNext()) {
            TableBase tableBase;
            PersistentStore persistentStore = (PersistentStore)iterator.next();
            if (persistentStore == null || (tableBase = persistentStore.getTable()).getTableType() != 5) continue;
            TableSpaceManager tableSpaceManager = dataFileCache.spaceManager.getTableSpace(tableBase.getSpaceID());
            persistentStore.setSpaceManager(tableSpaceManager);
        }
    }
}

