/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.RowAVL;
import org.evosuite.shaded.org.hsqldb.RowAction;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Table;
import org.evosuite.shaded.org.hsqldb.TableBase;
import org.evosuite.shaded.org.hsqldb.index.Index;
import org.evosuite.shaded.org.hsqldb.index.NodeAVL;
import org.evosuite.shaded.org.hsqldb.navigator.RowIterator;
import org.evosuite.shaded.org.hsqldb.persist.CachedObject;
import org.evosuite.shaded.org.hsqldb.persist.PersistentStoreCollection;
import org.evosuite.shaded.org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    Session session;

    public RowStoreAVLHybridExtended(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase, boolean bl) {
        super(session, persistentStoreCollection, tableBase, bl);
        this.session = session;
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        if (this.indexList != this.table.getIndexList()) {
            this.resetAccessorKeys(session, this.table.getIndexList());
        }
        return super.getNewCachedObject(session, object, bl);
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        if (this.isCached) {
            int n = cachedObject.getRealSize(this.cache.rowOut);
            n += this.indexList.length * 16;
            n = this.cache.rowOut.getStorageSize(n);
            cachedObject.setStorageSize(n);
            long l = this.tableSpace.getFilePosition(n, false);
            cachedObject.setPos(l);
            if (bl) {
                RowAction.addInsertAction(session, (Table)this.table, (Row)cachedObject);
            }
            this.cache.add(cachedObject);
        } else if (bl) {
            RowAction.addInsertAction(session, (Table)this.table, (Row)cachedObject);
        }
        Object[] objectArray = ((Row)cachedObject).getData();
        for (int i = 0; i < this.nullsList.length; ++i) {
            if (objectArray[i] != null) continue;
            this.nullsList[i] = true;
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        if (this.indexList != this.table.getIndexList()) {
            this.resetAccessorKeys(session, this.table.getIndexList());
            ((RowAVL)row).setNewNodes(this);
        }
        super.indexRow(session, row);
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                this.remove(row);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row);
                break;
            }
            case 3: {
                this.delete(session, row);
                this.remove(row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                this.remove(row);
            }
        }
    }

    @Override
    public void delete(Session session, Row row) {
        NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
        int n = 0;
        while (nodeAVL != null) {
            ++n;
            nodeAVL = nodeAVL.nNext;
        }
        if (this.isCached && row.isMemory() || n != this.indexList.length) {
            row = ((Table)this.table).getDeleteRowFromLog(session, row.getData());
        }
        if (row != null) {
            super.delete(session, row);
        }
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length || this.indexList[n] != index) {
            this.resetAccessorKeys(this.session, this.table.getIndexList());
            return this.getAccessor(index);
        }
        return this.accessorList[n];
    }

    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            this.resetAccessorKeysForCached();
            return;
        }
        super.resetAccessorKeys(session, indexArray);
    }

    private void resetAccessorKeysForCached() {
        RowStoreAVLHybridExtended rowStoreAVLHybridExtended = new RowStoreAVLHybridExtended(this.session, this.manager, this.table, true);
        rowStoreAVLHybridExtended.changeToDiskTable(this.session);
        RowIterator rowIterator = this.table.rowIterator(this);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            Row row2 = (Row)((RowStoreAVLHybrid)rowStoreAVLHybridExtended).getNewCachedObject(this.session, row.getData(), false);
            ((RowStoreAVLHybrid)rowStoreAVLHybridExtended).indexRow(this.session, row2);
        }
        this.indexList = rowStoreAVLHybridExtended.indexList;
        this.accessorList = rowStoreAVLHybridExtended.accessorList;
    }
}

